/*
 * 5799-WZQ (C) COPYRIGHT IBM CORPORATION 1986
 * LICENSED MATERIALS - PROPERTY OF IBM
 * REFER TO COPYRIGHT INSTRUCTIONS FORM NUMBER G120-2083
 */
/* $Header:hdr_formats.c 12.0$ */
/* $ACIS:hdr_formats.c 12.0$ */
/* $Source: /ibm/acis/usr/src/ibm/lpfilter/tools/RCS/hdr_formats.c,v $ */

#ifndef lint
static char *rcsid = "$Header:hdr_formats.c 12.0$";
#endif

#include <stdio.h>
#include <ctype.h>
#include <utils.h>
#include <hash.h>
#include <pmp/pmp.h>
#include <environ.h>
#include <header.h>
#include <hdr_formats.h>

/***===================================================================***/

#define WHERE_AM_I "hdr_formats.c"

int hdr_lnspace=0;
int hdr_fieldmargin=0;
int hdr_valuemargin=0;
int hdr_line=0;
int hdr_pgwidth=  2040;
int hdr_pgheight= 2640;

/***===================================================================***/

hdr_DrawBox(dist,width)
register1 int dist;
register2 int width;
{
    D_ENTRY2(hdr_debug,"hdr_DrawBox(%d,%d)\n",dist,width);
    p_vec_nofill();
    p_vec_set_width(width);
    p_mv_absolute(dist,dist);
    p_vec_absolute(hdr_pgwidth-dist,dist);
    p_vec_absolute(hdr_pgwidth-dist,hdr_pgheight-dist);
    p_vec_absolute(dist,hdr_pgheight-dist);
    p_vec_absolute(dist,dist);
    RETURN(TRUE);
}

/***============================================================***/

hdr_SetDefaults(env)
register1 environ *env;
{

    D_ENTRY1(hdr_debug,"hdr_SetDefaults(0x%x)\n",env);
    hdr_lnspace=     env_Int(env,"line_space",80);
    hdr_fieldmargin= env_Int(env,"field_left",400);
    hdr_valuemargin= env_Int(env,"value_left",840);
    hdr_line=        env_Int(env,"first_line",380);
    env_String(env,"hdr_base_font",DFL_BASE_FONT);
    env_String(env,"hdr_field_font",DFL_FIELD_FONT);
    env_String(env,"hdr_value_font",DFL_VALUE_FONT);
    RETURN(TRUE);
}

/***===================================================================***/

hdr_Field(field,value,ffont,vfont)
register1 char		*field;
register2 char		*value;
register3 pmp_font	*ffont;
register4 pmp_font	*vfont;
{
    D_ENTRY4(hdr_debug,"hdr_Field(%s,%s,0x%x,0x%x)\n",field,value,ffont,
								   vfont);
    if ((!value)||(!vfont))
       RETURN(FALSE);
    p_mv_v_absolute(hdr_line);
    if (field&&ffont) {
	p_mv_h_absolute(hdr_fieldmargin);
	p_puts(ffont,field);
    }
    if (hdr_valuemargin>0)
	p_mv_h_absolute(hdr_valuemargin);
    else
        p_mv_h_relative(-hdr_valuemargin);
    p_puts(vfont,value);
    hdr_line+= hdr_lnspace;
    RETURN(TRUE);
}

/***============================================================***/

hdr_BannerField(field,value)
register1 char	*field;
register2 char	*value;
{
    D_ENTRY2(hdr_debug,"hdr_BannerField(%s,%s)\n",field,value);
    if (!value) 
	RETURN(FALSE);
    p_mv_v_absolute(hdr_line);
    if (field) {
	p_mv_h_absolute(hdr_fieldmargin);
	ban_set_size(4);
	ban_putstr(field);
	if (hdr_valuemargin>0) 
	    p_mv_h_absolute(hdr_valuemargin);
	else
	    p_mv_h_relative(-hdr_valuemargin);
	ban_putstr(value);
    }
    else {
	register3 int width;
	
	ban_set_size(20);
	width= ban_strwidth(value);
	width= (p_get_pgwidth()-width)/2;
	p_mv_h_absolute(width);
	ban_putstr(value);
    }
    hdr_line+= (ban_height()*11)/10;
    RETURN(TRUE);
}

/***===================================================================***/

hdr_Development(outfil,env)
register2 FILE 		*outfil;
register1 environ 	*env;
{
	  int		 outer_border,outer_width;
	  int		 inner_border,inner_width;
	  int		 border_baseline;
register3 pmp_font	*nm_font;
register4 pmp_font	*fld_font;
register5 pmp_font	*val_font;
register6 pmp_font	*border_font;
	  char 		*user,*host;
	  char 		*top_field,*bottom_field;
	  char 		*left_field,*right_field;
	  char 		*message,*command,*files;

   D_ENTRY2(hdr_debug,"hdr_Development(0x%x,0x%x)\n",outfil,env);
   p_open(outfil);
   p_jog();
   hdr_SetDefaults(env);

   outer_border= env_Int(env,"hdr_outer_border",60);
   outer_width=  env_Int(env,"hdr_outer_width",8);
   inner_border= env_Int(env,"hdr_inner_border",170);
   inner_width=  env_Int(env,"hdr_inner_width",8);

   nm_font=  p_fnt_open(env_String(env,"hdr_name_font",DFL_NAME_FONT),
								P_ACIS_FONT);
   fld_font= p_fnt_open(env_String(env,"hdr_field_font",NULL),P_ACIS_FONT);
   val_font= p_fnt_open(env_String(env,"hdr_value_font",NULL),P_ACIS_FONT);
   border_font=  p_fnt_open(env_String(env,"hdr_border_font",DFL_BORDER_FONT),
								P_ACIS_FONT);

   if (outer_width)
      hdr_DrawBox(outer_border,outer_width);
   if (inner_width)
      hdr_DrawBox(inner_border,inner_width);
   
   top_field=    env_String(env,"hdr_top_msg",    DVL_TOP_MSG);
   left_field=   env_String(env,"hdr_left_msg",   DVL_LEFT_MSG);
   bottom_field= env_String(env,"hdr_bottom_msg", DVL_BTM_MSG);
   right_field=  env_String(env,"hdr_right_msg",  DVL_RT_MSG);

   border_baseline= env_Int(env,"hdr_border_baseline",15);

   p_fnt_activate(border_font);
   p_rotate(P_RIGHT_LANDSCAPE);
   p_mv_absolute(900,hdr_pgwidth-outer_border-border_baseline);
   p_putstring(left_field);
   p_rotate(P_LEFT_LANDSCAPE);
   p_mv_v_absolute(hdr_pgwidth-outer_border-border_baseline);
   p_putstring(right_field);
   p_rotate(P_PORTRAIT);
   p_mv_absolute(700,inner_border-border_baseline);
   p_putstring(top_field);
   p_mv_absolute(800,hdr_pgheight-outer_border-border_baseline);
   p_putstring(bottom_field);

   user=     env_String(env,"user",NULL);
   host=     env_String(env,"host",NULL);
   message=  env_String(env,"hdr_message",NULL);
   command=  env_String(env,"command",NULL);
   files=    env_String(env,"files",HDR_DFL_FILES);

   hdr_Field(NULL,            user,       NULL,     nm_font);
   hdr_Field("host",          host,       fld_font, val_font);
   hdr_Field("date",          u_Date(),   fld_font, val_font);
   hdr_Field("message",       message,    fld_font, val_font);
   hdr_Field("print command", command,    fld_font, val_font);
   hdr_Field("files",         files,      fld_font, val_font);
   if (StrMatch(env_String(env,"hdr_tray",HDR_DFL_TRAY),"main"))
   	  p_next_tray(P_MAIN_TRAY);
   else   p_next_tray(P_ALTERNATE_TRAY);
   p_next_copies(1);
   p_eject(TRUE);
   RETURN(TRUE);
}

/***===================================================================***/

hdr_Box(outfil,env)
register6 FILE *outfil;
register1 environ *env;
{
	  int 	 	 border,width;
register2 pmp_font	*nm_font;
register3 pmp_font	*fld_font;
register4 pmp_font	*val_font;
	  char 		*user,*host;
	  char 		*message,*command,*files;

   D_ENTRY2(hdr_debug,"hdr_Box(0x%x,0x%x)\n",outfil,env);
   p_open(outfil);
   p_jog();
   hdr_SetDefaults(env);

   border= env_Int(env,"hdr_border",60);
   width=  env_Int(env,"hdr_width",10);

   nm_font=  p_fnt_open(env_String(env,"hdr_name_font",DFL_NAME_FONT),
								P_ACIS_FONT);
   fld_font= p_fnt_open(env_String(env,"hdr_field_font",DFL_FIELD_FONT),
								P_ACIS_FONT);
   val_font= p_fnt_open(env_String(env,"hdr_value_font",DFL_VALUE_FONT),
								P_ACIS_FONT);

   if (width)
      hdr_DrawBox(border,width);
   
   user=     env_String(env,	"user",		NULL);
   host=     env_String(env,	"host",		NULL);
   message=  env_String(env,	"hdr_message",	NULL);
   command=  env_String(env,	"command",	NULL);
   files=    env_String(env,	"files",	HDR_DFL_FILES);

   hdr_Field(NULL,            user,       NULL,     nm_font);
   hdr_Field("host",          host,       fld_font, val_font);
   hdr_Field("date",          u_Date(),   fld_font, val_font);
   hdr_Field("message",       message,    fld_font, val_font);
   hdr_Field("print command", command,    fld_font, val_font);
   hdr_Field("files",         files,      fld_font, val_font);
   if (StrMatch(env_String(env,"hdr_tray",HDR_DFL_TRAY),"main"))
          p_next_tray(P_MAIN_TRAY);
   else   p_next_tray(P_ALTERNATE_TRAY);
   p_next_copies(1);
   p_eject(TRUE);
   RETURN(TRUE);
}
						
/***============================================================***/

hdr_Banner(outfil,env)
register2 FILE		*outfil;
register1 environ	*env;
{
int	border,width;
char	*user,*host;
char	*message;
char	*command,*files;

    D_ENTRY2(hdr_debug,"hdr_Banner(0x%x,0x%x)\n",outfil,env);
    p_open(outfil);
    p_jog();
    hdr_SetDefaults(env);
    border=	env_Int(env,"hdr_border",60);
    width=	env_Int(env,"hdr_width",10);
    if (width) 
	hdr_DrawBox(border,width);

    user=     env_String(env,	"user",		NULL);
    host=     env_String(env,	"host",		NULL);
    message=  env_String(env,	"hdr_message",	NULL);
    command=  env_String(env,	"command",	NULL);
    files=    env_String(env,	"files",	HDR_DFL_FILES);

    hdr_BannerField(NULL,            user);
    hdr_BannerField("host",          host);
    hdr_BannerField("date",          u_Date());
    hdr_BannerField("message",       message);
    hdr_BannerField("print command", command);
    hdr_BannerField("files",         files);
    if (StrMatch(env_String(env,"hdr_tray",HDR_DFL_TRAY),"main"))
           p_next_tray(P_MAIN_TRAY);
    else   p_next_tray(P_ALTERNATE_TRAY);
    p_next_copies(1);
    p_eject(TRUE);
    RETURN(TRUE);
}

/***===================================================================***/

hdr_NoHdr(outfil,env)
register1 FILE *outfil;
register2 environ *env;
{
    D_ENTRY2(hdr_debug,"hdr_NoHdr(0x%x,0x%x)\n",outfil,env);
    RETURN(TRUE);
}

