/*
 * 5799-WZQ (C) COPYRIGHT IBM CORPORATION 1986
 * LICENSED MATERIALS - PROPERTY OF IBM
 * REFER TO COPYRIGHT INSTRUCTIONS FORM NUMBER G120-2083
 */
/* $Header:header.c 12.0$ */
/* $ACIS:header.c 12.0$ */
/* $Source: /ibm/acis/usr/src/ibm/lpfilter/tools/RCS/header.c,v $ */

#ifndef lint
static char *rcsid = "$Header:header.c 12.0$";
#endif

#include <stdio.h>
#include <ctype.h>
#include <utils.h>
#include <hash.h>
#include <environ.h>
#include <header.h>
#include <hdr_formats.h>

#define hdr_Default hdr_Banner

/***===================================================================***/

int hdr_debug=0;
static int hdr_init= FALSE;

static hashtable *hdr_formats= NULL;

/***===================================================================***/

hdr_AddLayout(name,func)
register1 char *name;
register2 int (*func)();
{
    D_ENTRY2(hdr_debug,"hdr_AddLayout(%s,0x%x)\n",name,func);
    if (!hdr_formats)
       hdr_formats= ht_new(5);
    ht_put(hdr_formats,name,func);
    RETURN(TRUE);
}

/***===================================================================***/

hdr_Init()
{
    D_ENTRY(hdr_debug,"hdr_Init()\n");
    if (!hdr_init) {
	hdr_AddLayout("banner",hdr_Banner);
	hdr_AddLayout("development",hdr_Development);
        hdr_AddLayout("box",hdr_Box);
	hdr_AddLayout("no_header",hdr_NoHdr);
	hdr_init= FALSE;
    }
    RETURN(TRUE);
}

/***===================================================================***/

environ *
hdr_Print(outfil,env)
register1 FILE *outfil;
register2 environ *env;
{
register3 int (*func)();
register4 char *hdr_layout;

    D_ENTRY2(hdr_debug,"hdr_Print(0x%x,0x%x)\n",outfil,env);
    hdr_Init();
    hdr_layout= env_String(env,"hdr_layout",HDR_DFL_LAYOUT);
    func= (int (*)())ht_get(hdr_formats,hdr_layout);
    if (func)
         (*func)(outfil,env);
    else hdr_Default(outfil,env);
    RETURN(env);
}
