/*
 * 5799-WZQ (C) COPYRIGHT = NONE
 * LICENSED MATERIALS - PROPERTY OF IBM
 */
/* $Header:common.c 12.0$ */
/* $ACIS:common.c 12.0$ */
/* $Source: /ibm/acis/usr/src/ibm/rvd/client/RCS/common.c,v $ */

#ifndef lint
static char *rcsid = "$Header:common.c 12.0$";
#endif

/* This file is part of the Project Athena Remote Virtual Disk (RVD) libraries.
 *
 *	$Source: /ibm/acis/usr/src/ibm/rvd/client/RCS/common.c,v $
 *	$Author: root $
 *	$Header:common.c 12.0$
 *	$ACIS:common.c 12.0$
 */

#ifndef lint
static char *rcsid_common_c = "$Header:common.c 12.0$";
#endif lint

/* Copyright 1984 by the Massachusetts Institute of Technology */
/* See permission and disclaimer notice in the file "notice.h" */
#include "notice.h"

#include "common.h"
#include <setjmp.h>
#include <sys/socket.h>


unsigned long	rvderrno = 0;
static int _dflag = FALSE;	/* debugging msgs on/off */
#define debug if(_dflag)printf

void
common_debugOn()
{
	_dflag = TRUE;
}

void
common_debugOff()
{
	_dflag = FALSE;
}


int
stricmp(s1, s2)
    register char *s1, *s2;
{
    while (*s1 && *s2) {
        if (*s1 != *s2 && toupper(*s1) != toupper(*s2))
            return(1);
        s1++, s2++;
    }
    return(*s1 || *s2);
}

caddr_t
strc2s(c)
    char c;
{
    static char s[2] = {'\000','\000'};

    s[0] = c;
    return(s);
}

caddr_t
indexs(string, pattern)
    char *string;
    char *pattern;
{
    register int len = strlen(pattern);
    register char *s = string;
    register char *p = pattern;

    while (*s) {
        if (*p == *s && strncmp(p, s, len) == 0)
            return(s);
        s++;
    }
    return ((char *)0);
}

caddr_t
uppers(string)
    char *string;
{
    register char *cp = string;
    register char c;

    while (c = *cp) {
        if (c >= 'a' && c <= 'z')
            *cp = toupper(c);
        cp++;
    }
    return(string);
}

caddr_t
itoa(i)
    int i;
{
    static char num[8];

    sprintf(num, "%d", i);	     /* inefficient; use sparingly! */
    return(num);
}

caddr_t
basename(fn)
    char *fn;
{
    register char *cp;

    cp = index(fn, '\0');
    while (*--cp == '/')
        *cp = '\0';
    cp = rindex(fn, '/');
    if (cp)
        return(cp+1);
    return(fn);
}


void
etype(fmt, args)
    char *fmt;
{
    _doprnt(fmt, &args, stderr);
    fflush(stdout);
}


#include <nlist.h>

int
isWorkstation()
{
    static int myWorkstation = -1;
    struct nlist nl[2];

    if (myWorkstation >= 0)
        return(myWorkstation);

    nl[0].n_name = "_myKindOfWorkstation";
    nl[1].n_name = NULL;

    nlist("/vmunix", nl);
    if (nl[0].n_type)
        return(myWorkstation = nl[0].n_value);
    return(myWorkstation = 0);
}

sinaddr_p
in2sock(in)
    inaddr_t in;
{
	static sinaddr_t sin;

	sin.sin_family = AF_INET;
	sin.sin_addr = in;
	return(&sin);
}


#define SIGNALS (sigmask(SIGINT)|sigmask(SIGQUIT)|sigmask(SIGHUP))

void
signals_trap(sigfunc)
    int (*sigfunc)();
{
    static struct sigvec sv;

    sv.sv_handler = sigfunc;
    sv.sv_mask = SIGNALS;
    sv.sv_onstack = 0;

    sigvec(SIGHUP, &sv, NULL);
    sigvec(SIGQUIT, &sv, NULL);
    sigvec(SIGINT, &sv, NULL);
}

void
signals_off()
{
    (void) sigblock(SIGNALS);
}

void
signals_on()
{
    (void) sigsetmask(0);
}

void
panic(msg)
    char *msg;
{
    etype("\nPANIC: %s\n", msg);
    abort();
}

static int (*afunc)();

static int
handle_alarm()
{
	if (afunc)
		(*afunc)();
	return;
}

void
alarmClock(sec, func)
int sec;
int (*func)();
{
struct sigvec sv;

	sv.sv_handler = handle_alarm;
	sv.sv_mask = 0;
	sv.sv_onstack = 0;

	sec = (sec <= 0 ? 0 : sec);

	if (sec) {
		afunc = func;
		sigvec(SIGALRM, &sv, NULL);
	} else {
		afunc = NULL;
		signal(SIGALRM, SIG_DFL);
	}
	debug("alarmClock(%d)\n", sec);
	alarm(sec);
}
