/*
 * 5799-WZQ (C) COPYRIGHT = NONE
 * LICENSED MATERIALS - PROPERTY OF IBM
 */
/* $Header:rvd.c 12.0$ */
/* $ACIS:rvd.c 12.0$ */
/* $Source: /ibm/acis/usr/src/ibm/rvd/cntrl/RCS/rvd.c,v $ */

#ifndef lint
static char *rcsid = "$Header:rvd.c 12.0$";
#endif


#ifndef lint
static char *rcsid_rvd_c = "$Header:rvd.c 12.0$";
#endif	lint

/* Copyright 1984 by the Massachusetts Institute of Technology */
/* See permission and disclaimer notice in the file "notice.h" */
#include "notice.h"

#include	<stdio.h>
#include "logging.h"

extern errno;

char	*myname;
unsigned int	log_flag = LOG_ERR;

int	nullfunc();
int	rvdflush();
int	rvdgetm();
int	rvdsetm();
int	rvdchlog();
int	rvddown();
int	rvdlog();
int	rvdshut();
int	rvdexch();
int	rvdsend();
int	rvdshow();

struct rvd_cmds {
	char	*name;
	int	(*func)();
};
struct	rvd_cmds	rvd_norm_cmds[] = {
	"rvdflush", rvdflush,
	"rvdgetm", rvdgetm,
	"rvdsetm", rvdsetm,
	"rvdchlog", rvdchlog,
	"rvddown", rvddown,
	"rvdlog", rvdlog,
	"rvdshut", rvdshut,
	"rvdexch", rvdexch,
	"rvdsend", rvdsend,
	"rvdshow", rvdshow,
	0, nullfunc,
};
struct	rvd_cmds	rvd_short_cmds[] = {
	"flush", rvdflush,
	"getm", rvdgetm,
	"setm", rvdsetm,
	"chlog", rvdchlog,
	"log", rvdlog,
	"shut", rvdshut,
	"exch", rvdexch,
	"send", rvdsend,
	"show", rvdshow,
	0, nullfunc,
};


struct sockaddr_in	*resolve_host();

main(argc, argv)
int	argc;
char	**argv;
{
register struct	rvd_cmds	*cmd;
register char	*name;
char	*rindex();

	if((name = rindex(argv[0], '/')) == 0)
		myname = name = argv[0];
	else
		myname = ++name;

	if(strcmp(name, "rvd") == 0) {
		myname = name = *++argv;
		argc--;
		
		for(cmd = rvd_short_cmds; cmd->name; cmd++)
			if(strcmp(name, cmd->name) == 0 && cmd->func)
				return((*cmd->func)(argc, argv));
	}

	for(cmd = rvd_norm_cmds; cmd->name; cmd++)
		if(strcmp(name, cmd->name) == 0 && cmd->func)
			return((*cmd->func)(argc, argv));

	fprintf(stderr, "rvd: unkown cmd %s\n", name);
	return(1);
}

nullfunc()
{
}

char	*vdstate[] =
{	"spun-down",
	"uninitialized",
	"spin-up/wait",
	"spun-up",
	"spin-down/wait",
	"resyncing",
	"server crashed"
};
char	*access = "?rs?x";
