/*
 * 5799-WZQ (C) COPYRIGHT = NONE
 * LICENSED MATERIALS - PROPERTY OF IBM
 */
/* $Header:rvdexch.c 12.0$ */
/* $ACIS:rvdexch.c 12.0$ */
/* $Source: /ibm/acis/usr/src/ibm/rvd/cntrl/RCS/rvdexch.c,v $ */

#ifndef lint
static char *rcsid = "$Header:rvdexch.c 12.0$";
#endif


#ifndef lint
static char *rcsid_rvdexch_c = "$Header:rvdexch.c 12.0$";
#endif lint

/* Copyright 1984 by the Massachusetts Institute of Technology */
/* See permission and disclaimer notice in the file "notice.h" */
#include "notice.h"

/* Exchange the names of two RVD disks.
 */

#include	<stdio.h>
#include	<sys/types.h>
#include	<machineio/vdconst.h>

#define	BUFLEN	4096		/* Long enough to include an authenticator. */

rvdexch(argc, argv)
	int	argc;
	char	**argv;
{
	char	*server;
	char	pass1[VD_CAPAB_LEN+1];
	char	pass2[VD_CAPAB_LEN+1];
	unsigned long	uid1, uid2;
	char	sbuf[BUFLEN];
	int	debug = 0;
	extern	char	*myname;

	if(argc > 1 && ! strcmp(argv[1], "-d")) {
		++debug;
		--argc;
		++argv;
	}

	if (argc != 6) {
		fprintf(stderr,
			"usage: %s server name1 uid1 name2 uid2\n", myname);
		exit(1);
	}

	bzero(pass1, sizeof pass1);
	bzero(pass2, sizeof pass2);
	server = argv[1];
	if(sscanf(argv[3], "%D", &uid1) != 1 ||
			sscanf(argv[5], "%D", &uid2) != 1) {
		fprintf(stderr, "Pack Unique IDs must be numeric\n");
		exit(1);
	}

	/* Try an authenticated exchange first.
	 */
#ifdef	KERBEROS
	csprintf(sbuf, "operation=exchange_names\npassword1=\nname1=%s\nuid1=%D\npassword2=\nname2=%s\nuid2=%D\n",
	  argv[2], uid1, argv[4], uid2);
	if ( get_auth(sbuf, server, myname, debug) &&
	    (ctl_init_send_close(sbuf, server, debug) == NULL))
		exit(NULL);
#endif	KERBEROS


	/* The authenticated exchange failed so prompt for
	 * the passwords for each pack.
	 */
	(void)sprintf(sbuf, "Password for %s:", argv[2]);
	strncpy(pass1, getpass(sbuf), sizeof(pass1));
	(void)sprintf(sbuf, "Password for %s:", argv[4]);
	strncpy(pass2, getpass(sbuf), sizeof(pass2));


	csprintf(sbuf, "operation=exchange_names\npassword1=%s\nname1=%s\nuid1=%D\npassword2=%s\nname2=%s\nuid2=%D\n",
	  pass1, argv[2], uid1, pass2, argv[4], uid2);

	exit(ctl_init_send_close(sbuf, server, debug));
}
