/*
 * 5799-WZQ (C) COPYRIGHT = NONE
 * LICENSED MATERIALS - PROPERTY OF IBM
 */
/* $Header:rvdshut.c 12.0$ */
/* $ACIS:rvdshut.c 12.0$ */
/* $Source: /ibm/acis/usr/src/ibm/rvd/cntrl/RCS/rvdshut.c,v $ */

#ifndef lint
static char *rcsid = "$Header:rvdshut.c 12.0$";
#endif


#ifndef lint
static char *rcsid_rvdshut_c = "$Header:rvdshut.c 12.0$";
#endif lint

/* Copyright 1984 by the Massachusetts Institute of Technology */
/* See permission and disclaimer notice in the file "notice.h" */
#include "notice.h"


/* Shut down the RVD server.
 */

#include	<stdio.h>
#include	<sys/types.h>
#include	<machineio/vdconst.h>

#define	BUFLEN	4096		/* Long enough to include an authenticator. */
#define	NAMELEN	128		/* Maximum length of a server hostname.	*/


rvdshut(argc, argv)
	int	argc;
	char	**argv;
{
	register char	*pass;
	char	*server;
	char	server_name[NAMELEN];
	char	sbuf[BUFLEN];
	int	debug = 0;
	extern	char	*myname;

	if(argc > 1 && ! strcmp(argv[1], "-d")) {
		++debug;
		--argc;
		++argv;
	}

	/* If the RVD server name was not specified on the command
	 * line then assume the local machine.
	 */
	if (argc == 1) {
		if (gethostname(server_name, NAMELEN) != NULL) {
			perror(myname);
			exit(1);
		}
		server = server_name;
	} else if (argc == 2) {
		server = argv[1];
	} else {
		fprintf(stderr, "usage: %s [server]\n", myname);
		exit(1);
	}

	/* Try an authenticated shutdown first.
	 */
#ifdef	KERBEROS
	sprintf(sbuf, "operation=shutdown\npassword=\n");
	if ( get_auth(sbuf, server, myname, debug) && 
	    (ctl_init_send_close(sbuf, server, debug) == NULL))
		exit(NULL);
#endif	KERBEROS

	/* The authenticated shutdown failed so prompt for a password.
	 */
	csprintf(sbuf, "operation=shutdown\npassword=%s\n",
		getpass("Password: ", VD_CAPAB_LEN));

	exit(ctl_init_send_close(sbuf, server, debug));
}
