/*
 * 5799-WZQ (C) COPYRIGHT = NONE
 * LICENSED MATERIALS - PROPERTY OF IBM
 */
/* $Header:logging.h 12.0$ */
/* $ACIS:logging.h 12.0$ */
/* $Source: /ibm/acis/usr/src/ibm/rvd/h/RCS/logging.h,v $ */

#if !defined(lint) && !defined(LOCORE) && defined(RCS_HDRS)
static char *rcsidlogging = "$Header:logging.h 12.0$";
#endif


/* Copyright 1984 by the Massachusetts Institute of Technology */
/* See permission and disclaimer notice in the file "notice.h" */
#include "notice.h"
#include <sys/syslog.h>


/* Definitions related to event logging */

/* Returns TRUE iff logging at the specified level is on. */

#define	loglevel(lev)		(log_flag & (lev))

/* Turn on logging at the specified level */

#define	logon(lev)		(log_flag |= (lev))

/* Turn off logging at the specifed level */

#define	logoff(lev)		(log_flag &= ~(lev))

/* The logging flag */

extern	unsigned log_flag;


/* Macro to log the current time to the standard output */

#define	logtime()		syslog(LOG_INFO, "")


/* Currently defined logging levels */

#define	LOG_ERROR	  1	/* log all packet errors */
#define	LOG_SPINS	  2	/* log all activity, spinups, etc. */
#define	LOG_RDWR	  4	/* log all read and write requests */
#define	LOG_CLIENT_ERROR  8	/* log all client errors */
#define	LOG_TRACE	 16	/* log a full packet trace */
