/*
 * 5799-WZQ (C) COPYRIGHT = NONE
 * LICENSED MATERIALS - PROPERTY OF IBM
 */
/* $Header:physd.h 12.0$ */
/* $ACIS:physd.h 12.0$ */
/* $Source: /ibm/acis/usr/src/ibm/rvd/h/RCS/physd.h,v $ */

#if !defined(lint) && !defined(LOCORE) && defined(RCS_HDRS)
static char *rcsidphysd = "$Header:physd.h 12.0$";
#endif


/* Copyright 1984 by the Massachusetts Institute of Technology */
/* See permission and disclaimer notice in the file "notice.h" */
#include "notice.h"

/* This file contains the definitions for the physical disk descriptor
 * structure.  In the vd database program, these are created from the
 * database when the program is started, and by "add_physical" commands.
 *
 * Each in-core record contains information from an rvdmaster file record.
 */

#include "obj.h"

#define	NFILE		32	/* full name of physical disk */

struct	physd	{		/* physical disk descriptor */

/* The first three fields are not stored in the disk file */

	struct	physd	*pd_forw;	/* forward link */
	struct	physd	*pd_back;	/* backward link */
	obj_type	pd_type;	/* type code */

/* The next two fields are read in from the rvdmaster file */

	char		pd_file[NFILE];	/* file containing phys. disk */
	long		pd_blocks;	/* blocks on physical disk */

/* The following fields are read in from the database info file header */

	long		pd_created;	/* creation time of file */
	long		pd_modified;	/* last changed time */
	int		pd_disks;	/* number of virt disks on phys disk */
	int		pd_used;	/* number of used blocks */

/* The following fields are stored as spare space in the database info file */

	int		pd_fd;		/* file descriptor for reads/writes */
	int		pd_mode;	/* mode descriptor for physical disk. */
	struct virtd	*vd_forw;	/* head of this physd's virtual disks */
	struct virtd	*vd_back;	/* tail of this physd's virtual disks */
};

struct	physd_q	{			/* queue of physical disk descriptors */
	struct physd	*pq_forw;	/* forward link */
	struct physd	*pq_back;	/* backward link */
};

#define RVD_USE_PHYS	0x10		/* Use physical flag in pd_mode, set=disk ok */
