/*
 * 5799-WZQ (C) COPYRIGHT = NONE
 * LICENSED MATERIALS - PROPERTY OF IBM
 */
/* $Header:conn.h 12.0$ */
/* $ACIS:conn.h 12.0$ */
/* $Source: /ibm/acis/usr/src/ibm/rvd/server/RCS/conn.h,v $ */

#if !defined(lint) && !defined(LOCORE) && defined(RCS_HDRS)
static char *rcsidconn = "$Header:conn.h 12.0$";
#endif


/* Copyright 1984 by the Massachusetts Institute of Technology */
/* See permission and disclaimer notice in the file "notice.h" */
#include "notice.h"

/* Definitions for the conn structure, which contains the state of
 * a "connection" - that is, a spun up virtual disk.
 */

struct	conn	{			/* basic connection structure */
	struct	conn	*cn_forw;	/* forward link */
	struct	conn	*cn_back;	/* backward link */
	obj_type	cn_type;	/* object type field */

	struct	in_addr	cn_fhost;	/* foreign host for this conn */
	u_long		cn_drive;	/* foreign drive number */
	u_long		cn_nonce;	/* spinup nonce */
	u_long		cn_rbfactor;	/* read blocking factor */
	u_long		cn_index;	/* conn's index in all_conns array */

	struct	virtd	*cn_virtd;	/* virtual disk */

	struct	pkt_q	cn_reads;	/* read request queue */
	struct	pkt_q	cn_writes;	/* write request queue */
};


struct	conn_q	{			/* a queue of connections */
	struct	conn	*cq_forw;	/* forward link */
	struct	conn	*cq_back;	/* backward link */
};
