/*
 * 5799-WZQ (C) COPYRIGHT = NONE
 * LICENSED MATERIALS - PROPERTY OF IBM
 */
/* $Header:ctl_msgs.c 12.0$ */
/* $ACIS:ctl_msgs.c 12.0$ */
/* $Source: /ibm/acis/usr/src/ibm/rvd/server/RCS/ctl_msgs.c,v $ */

#ifndef lint
static char *rcsid = "$Header:ctl_msgs.c 12.0$";
#endif

#ifndef lint
static char rcsid_ctl_msgs_c[] = "$Header:ctl_msgs.c 12.0$";
#endif lint

/* Copyright 1984 by the Massachusetts Institute of Technology */
/* See permission and disclaimer notice in the file "notice.h" */
#include "notice.h"

/* This file contains the skeleton message descriptors for the
 * control messages presently accepted by the RVD server.  The
 * include file ctl_msgs.h defines the "field" offsets in each
 * descriptor.
 */

#include	<sys/types.h>
#include	<stdio.h>
#include	<ctype.h>
#include	"rvd_types.h"
#include	"ctl_pkt.h"
#include	"extern.h"


static struct	item	ITM_padd[] = {	/* add_physical */
	{ "password", NULL, TRUE },	/* ITM_PADD_PASSW */
	{ "filename", NULL, TRUE },	/* ITM_PADD_FILE */
	{ "blocks", NULL, TRUE },	/* ITM_PADD_BLOCKS */
	{ "created", NULL, FALSE },	/* ITM_PADD_CREATED */
	{ "modified", NULL, FALSE },	/* ITM_PADD_MODIFIED */
	{ "nonce", NULL, FALSE },	/* ITM_PADD_NONCE */
	{ "auth", NULL, FALSE }		/* ITM_PADD_AUTH */
};
static struct	item	ITM_vadd[] = {	/* add_virtual */
	{ "password", NULL, TRUE },	/* ITM_VADD_PASSW */
	{ "physical", NULL, TRUE },	/* ITM_VADD_PHYS */
	{ "name", NULL, TRUE },		/* ITM_VADD_NAME */
	{ "uid", NULL, TRUE },		/* ITM_VADD_UID */
	{ "owner", NULL, TRUE },	/* ITM_VADD_OWN */
	{ "rocap", NULL, TRUE },	/* ITM_VADD_ROCAP */
	{ "excap", NULL, TRUE },	/* ITM_VADD_EXCAP */
	{ "shcap", NULL, TRUE },	/* ITM_VADD_SHCAP */
	{ "modes", NULL, TRUE },	/* ITM_VADD_MODES */
	{ "blocks", NULL, TRUE },	/* ITM_VADD_BLOCKS */
	{ "ownhost", NULL, FALSE },	/* ITM_VADD_OWNH */
	{ "offset", NULL, TRUE },	/* ITM_VADD_OFF */
	{ "created", NULL, FALSE },	/* ITM_VADD_CREATED */
	{ "modified", NULL, FALSE},	/* ITM_VADD_MODIFIED */
	{ "nonce", NULL, FALSE },	/* ITM_VADD_NONCE */
	{ "auth", NULL, FALSE }		/* ITM_VADD_AUTH */
};
static struct	item	ITM_pdel[] = {	/* delete_physical */
	{ "password", NULL, TRUE },	/* ITM_PDEL_PASSW */
	{ "physical", NULL, FALSE },	/* ITM_PDEL_NAME */
	{ "nonce", NULL, FALSE },	/* ITM_PDEL_NONCE */
	{ "auth", NULL, FALSE }		/* ITM_PDEL_AUTH */
};
static struct	item	ITM_puse[] = {	/* use_physical */
	{ "password", NULL, TRUE },	/* ITM_PUSE_PASSW */
	{ "physical", NULL, TRUE },	/* ITM_PUSE_NAME */
	{ "nonce", NULL, FALSE },	/* ITM_PUSE_NONCE */
	{ "auth", NULL, FALSE }		/* ITM_PUSE_AUTH */
};
static struct	item	ITM_pduse[] = {	/* disuse_physical */
	{ "password", NULL, TRUE },	/* ITM_PDUSE_PASSW */
	{ "physical", NULL, TRUE },	/* ITM_PDUSE_NAME */
	{ "nonce", NULL, FALSE },	/* ITM_PDUSE_NONCE */
	{ "auth", NULL, FALSE }		/* ITM_PDUSE_AUTH */
};
static struct	item	ITM_vdel[] = {	/* delete_virtual */
	{ "password", NULL, TRUE },	/* ITM_VDEL_PASSW */
	{ "name", NULL, FALSE },	/* ITM_VDEL_NAME */
	{ "uid", NULL, FALSE },		/* ITM_VDEL_UID */
	{ "nonce", NULL, FALSE },	/* ITM_VDEL_NONCE */
	{ "auth", NULL, FALSE }		/* ITM_VDEL_AUTH */
};
static struct	item	ITM_vmod[] = {	/* modify_virtual */
	{ "password", NULL, TRUE },	/* ITM_VMOD_PASSW */
	{ "name", NULL, TRUE },		/* ITM_VMOD_NAME */
	{ "uid", NULL, FALSE },		/* ITM_VMOD_UID */
	{ "owner", NULL, FALSE },	/* ITM_VMOD_OWN */
	{ "rocap", NULL, FALSE },	/* ITM_VMOD_ROCAP */
	{ "excap", NULL, FALSE },	/* ITM_VMOD_EXCAP */
	{ "shcap", NULL, FALSE },	/* ITM_VMOD_SHCAP */
	{ "modes", NULL, FALSE },	/* ITM_VMOD_MODES */
	{ "blocks", NULL, FALSE },	/* ITM_VMOD_BLOCKS */
	{ "ownhost", NULL, FALSE },	/* ITM_VMOD_OWNH */
	{ "created", NULL, FALSE },	/* ITM_VMOD_CREATED */
	{ "modified", NULL, FALSE },	/* ITM_VMOD_MODIFIED */
	{ "nonce", NULL, FALSE },	/* ITM_VMOD_NONCE */
	{ "auth", NULL, FALSE }		/* ITM_VMOD_AUTH */
};
static struct	item	ITM_exch[] = {	/* exchange_names */
	{ "password1", NULL, TRUE },	/* ITM_VDEX_PASSW1 */
	{ "name1", NULL, TRUE },	/* ITM_VDEX_NAME1 */
	{ "uid1", NULL, TRUE },		/* ITM_VDEX_UID1 */
	{ "password2", NULL, TRUE },	/* ITM_VDEX_PASSW2 */
	{ "name2", NULL, TRUE },	/* ITM_VDEX_NAME2 */
	{ "uid2", NULL, TRUE },		/* ITM_VDEX_UID2 */
	{ "nonce", NULL, FALSE },	/* ITM_VDEX_NONCE */
	{ "auth", NULL, FALSE }		/* ITM_VDEX_AUTH */
};	
static struct	item	ITM_vdown[] = {	/* spindown_virtual */
	{ "password", NULL, TRUE },	/* ITM_VDOWN_PASSW */
	{ "name", NULL, TRUE },		/* ITM_VDOWN_NAME */
	{ "nonce", NULL, FALSE },	/* ITM_VDOWN_NONCE */
	{ "auth", NULL, FALSE }		/* ITM_VDOWN_AUTH */
};	
static struct	item	ITM_hdown[] = {	/* spindown_host */
	{ "password", NULL, FALSE },	/* ITM_HDOWN_PASSW */
	{ "name", NULL, TRUE },		/* ITM_HDOWN_NAME */
	{ "nonce", NULL, FALSE },	/* ITM_HDOWN_NONCE */
	{ "auth", NULL, FALSE }		/* ITM_HDOWN_AUTH */
};
static struct	item	ITM_vdisp[] = {	/* display_virtual */
	{ "name", NULL, FALSE },	/* ITM_VDISP_NAME */
	{ "host", NULL, FALSE },	/* ITM_VDISP_HOST */
	{ "file", NULL, FALSE },	/* ITM_VDISP_FILE */
	{ "start", NULL, FALSE },	/* ITM_VDISP_START */
	{ "password", NULL, FALSE },	/* ITM_VDISP_PASSW */
	{ "nonce", NULL, FALSE },	/* ITM_VDISP_NONCE */
	{ "auth", NULL, FALSE }		/* ITM_VDISP_AUTH */
};
static struct	item	ITM_adisp[] = {	/* display_active */
	{ "file", NULL, FALSE },	/* ITM_ADISP_FILE */
	{ "start", NULL, FALSE },	/* ITM_ADISP_START */
	{ "password", NULL, FALSE },	/* ITM_ADISP_PASSW */
	{ "nonce", NULL, FALSE }	/* ITM_ADISP_NONCE */
};
static struct	item	ITM_lext[] = {	/* log_external_stats */
	{ "password", NULL, TRUE },	/* ITM_LEXT_PASSW */
	{ "nonce", NULL, FALSE },	/* ITM_LEXT_NONCE */
	{ "auth", NULL, FALSE }		/* ITM_LEXT_AUTH */
};
static struct	item	ITM_lall[] = {	/* log_all_stats */
	{ "password", NULL, TRUE },	/* ITM_LALL_PASSW */
	{ "nonce", NULL, FALSE },	/* ITM_LALL_NONCE */
	{ "auth", NULL, FALSE }		/* ITM_LALL_AUTH */
};
static struct	item	ITM_ltrunc[] = { /* truncate log */
	{ "password", NULL, TRUE }	/* ITM_LTRUNC_PASSW */
};
static struct	item	ITM_llev[] = {	/* set log level */
	{ "level", NULL, TRUE },	/* ITM_LLEV_LEV */
	{ "password", NULL, TRUE },	/* ITM_LLEV_PASSW */
	{ "nonce", NULL, FALSE },	/* ITM_LLEV_NONCE */
	{ "auth", NULL, FALSE }		/* ITM_LLEV_AUTH  */
};
static struct	item	ITM_shut[] = {	/* shutdown */
	{ "password", NULL, TRUE },	/* ITM_SHUT_PASSW */
	{ "nonce", NULL, FALSE },	/* ITM_SHUT_NONCE */
	{ "auth", NULL, FALSE }		/* ITM_SHUT_AUTH  */
};
static struct	item	ITM_smod[] = {	/* spin_modes */
	{ "password", NULL, TRUE },	/* ITM_SMOD_PASSW */
	{ "name", NULL, FALSE },	/* ITM_SMOD_NAME */
	{ "mode", NULL, TRUE },		/* ITM_SMOD_MODES */
	{ "nonce", NULL, FALSE },	/* ITM_SMOD_NONCE */
	{ "auth", NULL, FALSE }		/* ITM_SMOD_AUTH */
};
static struct	item	ITM_setm[] = {	/* set_message */
	{ "password", NULL, TRUE },	/* ITM_SETM_PASSW */
	{ "message", NULL, FALSE },	/* ITM_SETM_MESSAGE */
	{ "nonce", NULL, FALSE },	/* ITM_SETM_NONCE */
	{ "auth", NULL, FALSE }		/* ITM_SETM_AUTH */
};
static struct	item	ITM_getm[] = {	/* get_message */
	{ "nonce", NULL, FALSE }	/* ITM_GETM_NONCE */
};
static struct	item	ITM_rauth[] = {	/* require_authorization */
	{ "nonce", NULL, FALSE }	/* ITM_RAUTH_NONCE */
};

#ifdef	TEST_SERVER
static struct	item	ITM_tenter[] = {	/* test_enter */
	{ "password", NULL, TRUE },	/* ITM_TENTER_PASSW */
	{ "spin_errors", NULL, TRUE },	/* ITM_TENTER_SPIN_ERROR */
	{ "read_errors", NULL, TRUE },	/* ITM_TENTER_READ_ERROR */
	{ "write_errors", NULL, TRUE },	/* ITM_TENTER_WRITE_ERROR */
	{ "nonce", NULL, FALSE },	/* ITM_TENTER_NONCE */
};

static struct	item	ITM_texit[] = {	/* test_exit */
	{ "nonce", NULL, FALSE },	/* ITM_TEXIT_NONCE */
};

int	ctl_tenter();
int	ctl_texit();
#endif	TEST_SERVER

/* This is the table of all allowable messages */

static struct	msg	all_msgs[] = {	/* all allowable message descriptors */
	{ "allow_spinups", ITM_smod, nitems(ITM_smod), cn_modes },
	{ "add_physical", ITM_padd, nitems(ITM_padd), pd_add },
	{ "add_virtual", ITM_vadd, nitems(ITM_vadd), vd_add },
	{ "delete_physical", ITM_pdel, nitems(ITM_pdel), pd_del },
	{ "use_physical", ITM_puse, nitems(ITM_puse), pd_use },
	{ "disuse_physical", ITM_pduse, nitems(ITM_pduse), pd_duse },
	{ "delete_virtual", ITM_vdel, nitems(ITM_vdel), vd_del },
	{ "display_active", ITM_adisp, nitems(ITM_adisp), cn_adisp },
	{ "display_virtual", ITM_vdisp, nitems(ITM_vdisp), cn_vdisp },
	{ "exchange_names", ITM_exch, nitems(ITM_exch), vd_exch },
	{ "get_message", ITM_getm, nitems(ITM_getm), ctl_getm },
	{ "log_all_statistics", ITM_lall, nitems(ITM_lall), ctl_lall },
	{ "log_external_statistics", ITM_lext, nitems(ITM_lext), ctl_lext },
	{ "log_level", ITM_llev, nitems(ITM_llev), ctl_llev },
	{ "log_truncate", ITM_ltrunc, nitems(ITM_ltrunc), ctl_ltrunc },
	{ "modify_virtual", ITM_vmod, nitems(ITM_vmod), vd_mod },
	{ "require_authorization", ITM_rauth, nitems(ITM_rauth), ctl_rauth },
	{ "set_message", ITM_setm, nitems(ITM_setm), ctl_setm },
	{ "shutdown", ITM_shut, nitems(ITM_shut), ctl_shut },
	{ "spindown_host", ITM_hdown, nitems(ITM_hdown), cn_hdown },
	{ "spindown_virtual", ITM_vdown, nitems(ITM_vdown), cn_vdown },
#ifdef	TEST_SERVER
	{ "test_enter", ITM_tenter, nitems(ITM_tenter), ctl_tenter },
	{ "test_exit", ITM_texit, nitems(ITM_texit), ctl_texit },
#endif	TEST_SERVER
};

#define	NMSGS	(sizeof(all_msgs)/sizeof(struct msg))


/* Look up the specified opcode in the table of allowable messages and
 * return a pointer to the message descriptor.  Return NULL if there
 * is no such opcode.
 */

struct msg *
ctl_msg(opcode)

register char	*opcode;			/* opcode name */
{
	register struct	msg	*msgp;		/* temp for message ptr */

	for (msgp = &all_msgs[0]; msgp < &all_msgs[NMSGS]; msgp++)
		if (strcmp(msgp->ms_opcode, opcode) == 0)
			return(msgp);
	return(NULL);
}


/* Look up the specified keyword in the specified skeleton item list and
 * return a pointer to the item descriptor in the list.  If the keyword
 * is not found, return NULL.
 */

struct item *
ctl_item(skel, skellen, key)

register struct	item	skel[];			/* skeleton item list */
register int	skellen;			/* number of items in list */
register char	*key;				/* keyword to look up */
{
	register struct	item	*itp;		/* temp for search */
		
	for (itp = &skel[0]; itp < &skel[skellen]; itp++)
		if (strcmp(itp->it_key, key) == 0)
			return(itp);
	return(NULL);
}
