/*
 * 5799-WZQ (C) COPYRIGHT IBM CORPORATION 1988
 * LICENSED MATERIALS - PROPERTY OF IBM
 * REFER TO COPYRIGHT INSTRUCTIONS FORM NUMBER G120-2083
 */
/* $Header: /usr/src/usr.ibm/pp4216/ldps/RCS/ldps.c,v 1.2 1995/03/22 17:50:12 md Exp $ */
/* $ACIS:ldps.c 12.2$ */
/* $Source: /usr/src/usr.ibm/pp4216/ldps/RCS/ldps.c,v $ */

#ifndef lint
static char *rcsid = "$Header: /usr/src/usr.ibm/pp4216/ldps/RCS/ldps.c,v 1.2 1995/03/22 17:50:12 md Exp $";
#endif


/*
 *
 *  ldps -- Load the PostScript interpreter into the 4216 Personal
 *          Pageprinter adapter
 *
 *   
 *     usage:  ldps [-Ppsdevname] filename
 *
 */ 

#include <stdio.h>
#include <fcntl.h>
#include <sys/psioctl.h>

#define MAXPACKETSIZE 1028

#define	DEVNAME(x)	strlen(x) ? x : "stdout"

int ucode, ps;

char filebuff[MAXPACKETSIZE+2];  /* the extra two bytes is just for slop */
short packetbuff[MAXPACKETSIZE/2];


char *usage = "usage: ldps [-fpsdevname] ucodefile\n";
char msgbuff[128];

main(argc, argv)
     int argc;
     char **argv;

{
    short xferlen, stat;
    int totalxfered;
    char *psdevname;
    char *ucodename;
    char *argp;


    if (argc == 2) {
        ucodename = argv[1];
        psdevname = "";
    }
    else if (argc == 3) {
        argp = argv[1];
        ucodename = argv[2];
        if (!(*argp == '-' && argp[1] == 'f')) {
            fprintf(stderr, usage);
            exit(2);
        }
        else psdevname = argp+2;
    }
    else {
        fprintf(stderr, usage);
        exit(2);
    }

    if (strlen(psdevname))
	ps = open(psdevname, O_RDWR);
    else
	ps = 1; /* stdout */
    if (ps < 0) {
	sprintf(msgbuff, "ldps: %s open failed", psdevname);
        perror(msgbuff);
	exit(2);
    }
    ucode = open(ucodename, O_RDONLY);
    if (ucode < 0) {
        fprintf(stderr, "ucode file %s not found", ucodename);
        exit(2);
    }


    stat = ioctl(ps, PSRESET, 0);
    if (stat < 0 ) {
        sprintf(msgbuff, "%s reset failed\n", DEVNAME(psdevname));
        perror(msgbuff);
        exit(2);
    }
    stat = ioctl(ps, PSREADPACKET, 0);
    if (stat < 0 ) {
        sprintf(msgbuff, "%s READPACKET ioctl failed\n", DEVNAME(psdevname));
        perror(msgbuff);
        exit(2);
    }
    stat = ioctl(ps, PSWRITEPACKET, 0);
    if (stat < 0 ) {
        sprintf(msgbuff, "%s WRITEPACKET ioctl failed\n", DEVNAME(psdevname));
        perror(msgbuff);
        exit(2);
    }
    sleep(20); 
   
    totalxfered = 0;
    do {
        xferlen = readiplpacket(ucode, packetbuff);
        if (xferlen > 0) {
            stat = write(ps, packetbuff, xferlen);
            if (stat < 0 ) {
                fprintf(stderr, "ldfnt: write failed in ucode xfer. status = %x\n", stat);
                exit(2);
            }
            totalxfered += xferlen;
        }
    } while(xferlen > 0 && stat >= 0);
    if (stat >= 0)
	fprintf(stderr, "ucode loaded on %s. total xferred is %d\n", 
		DEVNAME(psdevname), totalxfered);
    sleep(5);
    close(ucode);
#ifdef	FLUSH_NORMAL
    stat = ioctl(ps, PSREADNORMAL, 0);
    if (stat < 0 ) {
        sprintf(msgbuff, "%s READNORMAL ioctl failed\n", DEVNAME(psdevname));
        perror(msgbuff);
        exit(2);
    }
#endif
    stat = read(ps, packetbuff, 1028);  /* Clear the adapter output buffer */
    if (!strlen(psdevname))
	ioctl(ps, PSENDIPL, 0);
    else
	close(ps);
    exit(0);
}





int readiplpacket(f, pktbuff)
          int   f;
          short *pktbuff;

{ short len, type;
  int stat;
 
    stat = read(f, &len, 2);
    if ( stat <= 0 ) return stat;
    stat = read(f, &type, 2);
    if ( stat <= 0 ) return stat;
    stat = read(f, pktbuff+2, len);
    if ( stat <= 0 ) return stat;
    *pktbuff = len;
    pktbuff[1] = type; 

    return len+4;
}
