#include <stdio.h>

/* following should get us to /usr/sys_ca/standca
 * (if not too many symblic links are used
 */
#include "rt/stand/debug.h"
#include <sys/types.h>
#include <netinet/in.h>
#include <a.out.h>


/*
 * make a symbol table suitable for the debugger from the output
 * of 'nm'.
 * input is of the form: address letter symbol 
 */

#define MAXSYMSIZE 100
FILE *infile = NULL;
int outsize = 0;		/* output file size */
struct exec header = { MID_IBM_ROMP, OMAGIC };
char symbol[MAXSYMSIZE];
int addr;
char letter[10];
struct symtab sym;
int hflg;			/* -h (header) specified */
int nflg;			/* -n (no byte swapping) specified */
FILE *outfile = stdout;		/* output file */

main(argc,argv) char **argv;
{
register int i;
register char *argp;

for (i=1; i<argc; ++i)
	{
	argp = argv[i];
	if (*argp == '-')
		switch(argp[1])
			{
		case 'n':
			++nflg;
			break;
		case 'h':	/* produce an a.out header */
			++hflg;
			if (outsize)
				err("-h must be first");
			fwrite(&header,sizeof header,1,outfile);
			break;
		case 'o':	/* -o output-file */
			if (hflg)
				err("-o must appear before -h ");
			if ((outfile = fopen(argv[++i],"w")) == NULL)
				err("could not open %s for output",argv[i]);
			break;
		default:
			err("bad option %s",argp);
			break;
			}
	else
		{
		if ((infile = fopen(argp,"r")) == NULL)
			err("can't open %s",argp);
		dofile(infile);
		fclose(infile);
		}
	}
if (infile == NULL)
	dofile(stdin);
if (hflg)
	{
	header.a_text = outsize;
	if (fseek(outfile,(long) 0, 0) < 0)	/* point to start of file again */
		err("could not reposition outfile (pipe?)");
	fwrite(&header,sizeof header,1,outfile);
	}
exit(0);
}

dofile(file) register FILE *file;
{
while (fscanf(file,"%x %1s %100s\n",&addr,letter,symbol) == 3)
	{
	if (symbol[0] != '_')
		continue;
	if (nflg)
		sym.value = (addr);
	else
		sym.value = htonl(addr);
	strncpy(sym.symbol,symbol+1,sizeof sym.symbol);
	fwrite(&sym,sizeof sym,1,outfile);
	outsize += sizeof sym;
	}
}


err(s,d1,d2,d3,d4)
char *s;
{
warn(s,d1,d2,d3,d4);
exit(1);
}

warn(s,d1,d2,d3,d4)
char *s;
{
extern errno;

fflush(stdout);
fprintf(stderr,s,d1,d2,d3,d4);
if(errno > 0)
	{
	fprintf(stderr," - ");
	perror("");
	}
else
	fprintf(stderr,"\n");
}
