#! /bin/sh
#
# 5799-WZQ (C) COPYRIGHT IBM CORPORATION 1987
# LICENSED MATERIALS - PROPERTY OF IBM
# REFER TO COPYRIGHT INSTRUCTIONS FORM NUMBER G120-2083
#
# $Header: /usr/src/usr.ibm/sym/scripts/RCS/fixsyms.sh,v 1.2 1994/05/10 19:33:05 roger Exp $ 
# $ACIS:fixsyms 12.0$ 
# $Source: /usr/src/usr.ibm/sym/scripts/RCS/fixsyms.sh,v $ 

#
# fixsyms [file] [outfile]
#
# clean up ncs symbols 
#
rmfile=
case "$1" in
"")
	file=/tmp/$$fixsym
	rmfile="rm -f $file"
	cat $1 > $file
	;;
*)
	file=$1
	;;
esac
if /usr/libexec/old.egrep -s '_\.' $file
then
	awk '
#
# script to fix up the output from nm by replacing 
# all symbols _x where a _.x exists.
#
# input is of form
#    $1      $2   $3
# address letter symbol
#
#
($2 == "T" || $2 == "t") && $3 ~ /^_\./ {
	name= "_" substr($3,3)
	names[name] = $1
	next
	}
names[$3] != "" {
	next
	}
{
names[$3] = $1
}

END {
	for (i in names)
		print names[i], "=", i
}
' $file | sort 
else
	cat $file 
fi >$2
eval "$rmfile"
