/* gc.c - generates the required mappings */

# ifndef lint
static char Rcsid[] = "@(#)$Header: /usr/src/usr.sbin/sendmail-5.65c+IDA-1.4.4.1/ida/charset/gc/RCS/gc.c,v 1.2 1993/03/16 21:44:20 md Exp $";
# endif

/*
 * $Header: /usr/src/usr.sbin/sendmail-5.65c+IDA-1.4.4.1/ida/charset/gc/RCS/gc.c,v 1.2 1993/03/16 21:44:20 md Exp $
 *
 * $Log: gc.c,v $
 * Revision 1.2  1993/03/16  21:44:20  md
 * reno mods
 *
 * Revision 1.1  1991/04/05  16:47:30  md
 * Initial revision
 *
 */

#include	<stdio.h>
#include	<ctype.h>
#include	"charset.h"

#define	AMAX	2000

/* extern char	*fsets, *fdefs, *fmap, *fmnem; */
#ifndef	CHARSETS
#define	CHARSETS "CHARSETS";
#endif
#ifndef	CHARDEFS
#define	CHARDEFS "CHARDEFS";
#endif
#ifndef	CHARMAP
#define	CHARMAP "CHARMAP.10646";
#endif
#ifndef	MNEM
#define	MNEM "MNEM";
#endif

char fsets[] = CHARSETS;
char fdefs[] = CHARDEFS;
char fmap[]  = CHARMAP;
char fmnem[] = MNEM;
char csdir[] = "cs";

FILE		*f,*g,*h;
CHAR8U		s[LSIZE], c[AMAX], ref[C256], cmd[LSIZE];
INT16S		v[AMAX], l[AMAX], codetable[C256];
int		i,mx,a,cv,val,cod,dupl,ecma,line,group,plane,row,cell,num;

gwrite() {
	if (g) {
		for (i= 0; i < C256; i++)
		c[codetable[i]] = i;
		fwrite (codetable,2,C256,g);
		fwrite (c,1,mx,g);
		fclose (g);
	}
}

FILE *
fopener (file,mode)
char *file, *mode;
{
	FILE *f;
	f= fopen (file,mode);
	if (f == (FILE *)NULL) {
		fprintf (stderr,"*** Error: unable to open %s\n", file);
		exit (1);
	}
	return f;
}

main (argc,argv) int argc; char **argv; {
	CHAR8U	defname[LSIZE], linkname[LSIZE], *p;

	mx= 0; line= 0;

	f= fopener (fdefs,"r");
	h= fopener (fmap,"w");

	v[mx++]= '?' * C256 +'?';
	while (fgets (s,LSIZE,f)) {
		line++;
		if (mx > AMAX) perror ("Warning: too many chars\n");
		if (s[0] != ' ' && strlen (s) > 2) {
			v[mx++]= s[0]* C256 + s[1]; l[mx]= line;
			for (i=0; i < mx-1; i++) if (v[mx-1] == v[i])
			printf ("Warning: char %2.2s occurs in line %d and %d\n",
			s,l[i+1],line);
			fprintf (h,"%2.2s\t,,,%.3d,,,%.3d,,,%.3d,,,%.3d\t%s",
			s,group,plane,row,cell,s+3);
			cell++;
		}
		else if (strlen (s) >3 ){
			sscanf (s," %s %d", cmd, &num);
			for (p=cmd; *p; p++) if (isupper (*p)) *p= tolower (*p);
			/* printf ("command %s %d\n",cmd,num); */
			if (strcmp (cmd,"group") == 0) group=num;
			else if (strcmp (cmd,"plane") == 0) plane=num;
			else if (strcmp (cmd,"row") == 0) row=num;
			else if (strcmp (cmd,"cell") == 0) cell=num;
		}
	}
	printf ("%d chars defined\n",mx);
	fclose (f); fclose (h);

	f= fopener (fsets,"r");

	if (chdir (csdir)) printf ("Warning: cannot cd to %s\n",csdir);

	v[0]= mx;
	g= fopener (fmnem,"w");

	fwrite (v,2,mx,g);
	v[0]= '?' * C256 +'?';

	while (fscanf (f,"%s",s) != EOF) {
		if (strlen (s) == 1) { s[1]= ' '; s[2]= '\0'; }
		cv= s[0]* C256 + s[1];
		if (strlen (s) != 2) {
			if (strcmp (s,"referenceset") == 0) {
				fgets (ref+32,40,f); /* skip rest of line */
				fgets (ref+32,40,f);
				fgets (ref+64,40,f);
				fgets (ref+96,40,f);
				for (i=0; i< 32; i++) ref[i]= 0;
				for (i=33; i< C256; i++)
				if (ref[i] <= ref[32]) ref[i]= 0;
				fwrite (ref,1,C256,g);
				fclose (g); g= NULL;
			} else if (strcmp (s,"charset") == 0) {
				fscanf (f,"%s",defname);
				gwrite();
				for (p= defname; *p; p++)
				if (islower (*p)) *p= toupper (*p);
				g= fopener (defname,"w");
				cod= 0; ecma= 0;
				for (i= 0; i < mx; i++) c[i] = 0;
				for (i=0; i< C256; i++) codetable[i]= 0;
			} else if (strcmp (s,"alias") == 0) {
				fscanf (f,"%s",linkname);
				for (p= linkname; *p; p++)
				if (islower (*p)) *p= toupper (*p);
				unlink (linkname);
				link (defname,linkname);
			} else if (strcmp (s,"ecma") == 0) {
				ecma= fscanf (f,"%s",s);
				if (s[0] == 'o') sscanf (s+1,"%o",&ecma);
				else if (s[0] == 'x') sscanf (s+1,"%x",&ecma);
				else sscanf (s,"%d",&ecma);
			} else if (strcmp (s,"code") == 0) {
				cod= fscanf (f,"%s",s);
				if (s[0] == 'o') sscanf (s+1,"%o",&cod);
				else if (s[0] == 'x') sscanf (s+1,"%x",&cod);
				else sscanf (s,"%d",&cod);
			} else if (strcmp (s,"duplicate") == 0) {
				dupl= fscanf (f,"%s",s);
				if (s[0] == 'o') sscanf (s+1,"%o",&dupl);
				else if (s[0] == 'x') sscanf (s+1,"%x",&dupl);
				else sscanf (s,"%d",&dupl);
				if (dupl <0 || dupl >= C256 ||  
				! codetable[dupl])
				printf ("Warning: charset %s has duplicate %d but no original\n",defname,dupl);
				fscanf (f,"%s",s);
				if (strlen (s) == 1) { s[1]= ' '; s[2]= '\0'; }
				cv= s[0]* C256 + s[1];
				for (i= 0; i < mx && cv != v[i]; i++);
				if (i >= mx) printf ("Warning: charset %s duplicate %d %s unknown\n",defname,dupl,s);
				c[i] = dupl;
			} else printf ("Warning: charset %s unknown command '%s'\n",defname,s);
		} else {
			for (i= 0; i < mx && cv != v[i]; i++);
			if (i >= mx) printf ("charset %s char %s %d not defined\n",defname,s,cod++);
			else  {
				val= i;
				if (val) for (i=0; i <= cod && codetable[i] != val; i++);
				if (val && codetable[i] == val)
				printf ("Warning: charset %s char %s occurs twice %d %d\n",defname,s,i,cod);
				codetable[cod++]= val;
			}
		}
	}
	fclose (f);
	gwrite();
	exit (0);
}
