#include <ctype.h>
#include <stdio.h>

static char RCSid[] = "$Header: misc.c,v 2.2 85/09/18 21:03:08 essick Exp $";

/*
 *	random routines that I find helpful every now and
 *	then.
 */

/*
 *	save a copy of a string somewhere using malloc().
 */
char   *strsave (p)
char   *p;
{
    register char  *hold;
    register int    len;
    extern char *malloc ();

    if (p == (char *) NULL)
	return (char *) NULL;

    hold = malloc ((len = strlen (p) + 1));		/* include null */
    if (hold == (char *) NULL)
    {
	fprintf (stderr, "Unable to malloc %d bytes.\n",
		strlen (p) + 1);
	exit (1);
    }
    strncpy (hold, p, len);
    return (hold);
}

/*
 * case insensitive string comparison
 *	== 0 if true. <0 if first "less", else > 0
 */

int     strsame (a, b)
register char  *a;
register char  *b;
{
    register char   aa;
    register char   bb;

    if (a == (char *) NULL)
	return (-1);
    if (b == (char *) NULL)
	return (1);
    while (*a && *b)					/* got strings left */
    {
	aa = isupper (*a) ? tolower (*a) : *a;
	bb = isupper (*b) ? tolower (*b) : *b;
	if (aa < bb)
	    return (-1);
	if (aa > bb)
	    return (1);
	a++;
	b++;						/* next ones */
    }
    if (*a)
	return (1);
    if (*b)
	return (-1);
    return (0);
}

/* 
 * one which limits the length
 */
int     strnsame (a, b, length)
register char  *a;
register char  *b;
int     length;
{
    register char   aa;
    register char   bb;

    if (a == (char *) NULL)
	return (-1);
    if (b == (char *) NULL)
	return (1);
    while (*a && *b)					/* got strings left */
    {
	aa = isupper (*a) ? tolower (*a) : *a;
	bb = isupper (*b) ? tolower (*b) : *b;
	if (aa < bb)
	    return (-1);
	if (aa > bb)
	    return (1);
	a++;
	b++;						/* next ones */
	if (--length <= 0)
	    return (0);					/* same */
    }
    if (*a)
	return (1);
    if (*b)
	return (-1);
    return (0);
}

/*
 *	strlower(p)
 *
 *	turn a given string into all lower case letters.
 *	convert it in place.
 */

int     strlower (p)
char   *p;
{
    register char  *pp = p;

    while (*pp)
    {
	if (isascii (*pp) && isupper (*pp))
	    *pp = tolower (*pp);			/* make lower case */
	pp++;						/* and to next */
    }
    return (0);						/* all done */
}
