
/***************************************************************************
*                            COPYRIGHT NOTICE                              *
****************************************************************************
*                ncurses is copyright (C) 1992-1995                        *
*                          Zeyd M. Ben-Halim                               *
*                          zmbenhal@netcom.com                             *
*                          Eric S. Raymond                                 *
*                          esr@snark.thyrsus.com                           *
*                                                                          *
*        Permission is hereby granted to reproduce and distribute ncurses  *
*        by any means and for any fee, whether alone or as part of a       *
*        larger distribution, in source or in binary form, PROVIDED        *
*        this notice is included with any such distribution, and is not    *
*        removed from any of its header files. Mention of ncurses in any   *
*        applications linked with it is highly appreciated.                *
*                                                                          *
*        ncurses comes AS IS with no warranty, implied or expressed.       *
*                                                                          *
***************************************************************************/

/* $Id: curses.h.in,v 1.36 1996/11/16 21:55:54 tom Exp $ */

#ifndef __NCURSES_H
#define __NCURSES_H
#define CURSES 1
#define CURSES_H 1
#define NCURSES_VERSION "1.9.9g"

#ifndef _UNCTRL_H
typedef unsigned long  chtype;
#endif

#include <stdio.h>
#include <unctrl.h>
#include <stdarg.h>	/* we need va_list */
#ifdef _XOPEN_SOURCE_EXTENDED
#include <stddef.h>	/* we want wchar_t */
#endif /* _XOPEN_SOURCE_EXTENDED */

/* XSI and SVr4 specify that curses implements 'bool'.  However, C++ may also
 * implement it.  If so, we must use the C++ compiler's type to avoid conflict
 * with other interfaces.
 *
 * To simplify use with/without the configuration script, we define the symbols
 * CXX_BUILTIN_BOOL and CXX_TYPE_OF_BOOL; they're edited by the configure
 * script.
 */

#undef TRUE
#undef FALSE
#define CXX_BUILTIN_BOOL 0
#define CXX_TYPE_OF_BOOL unsigned

#if defined(__cplusplus) && CXX_BUILTIN_BOOL
#define TRUE    ((CXX_TYPE_OF_BOOL)true)
#define FALSE   ((CXX_TYPE_OF_BOOL)false)
#else
typedef CXX_TYPE_OF_BOOL bool;
#define TRUE    ((bool)1)
#define FALSE   ((bool)0)
#endif

#ifdef __cplusplus
extern "C" {
#endif

/*
 * XSI attributes.  In the ncurses implementation, they are identical to the
 * A_ attributes because attr_t is just an int.  The XSI Curses attr_* and
 * wattr_* entry points are all mapped to attr* and wattr* entry points.
 */
#define WA_ATTRIBUTES	0xffffff00
#define WA_NORMAL	0x00000000
#define WA_STANDOUT	0x00010000
#define WA_UNDERLINE	0x00020000
#define WA_REVERSE	0x00040000
#define WA_BLINK	0x00080000
#define WA_DIM		0x00100000
#define WA_BOLD		0x00200000
#define WA_ALTCHARSET	0x00400000
#define WA_INVIS	0x00800000
#define WA_PROTECT	0x01000000
#define WA_HORIZONTAL	0x02000000	/* XSI Curses attr -- not yet used */
#define WA_LEFT		0x04000000	/* XSI Curses attr -- not yet used */
#define WA_LOW		0x08000000	/* XSI Curses attr -- not yet used */
#define WA_RIGHT	0x10000000	/* XSI Curses attr -- not yet used */
#define WA_TOP		0x20000000	/* XSI Curses attr -- not yet used */
#define WA_VERTICAL	0x40000000	/* XSI Curses attr -- not yet used */

/* colors */
extern int COLORS;
extern int COLOR_PAIRS;

#define COLOR_BLACK	0
#define COLOR_RED	1
#define COLOR_GREEN	2
#define COLOR_YELLOW	3
#define COLOR_BLUE	4
#define COLOR_MAGENTA	5
#define COLOR_CYAN	6
#define COLOR_WHITE	7

/* line graphics */

extern	chtype acs_map[];

/* VT100 symbols begin here */
#define ACS_ULCORNER	(acs_map['l'])	/* upper left corner */
#define ACS_LLCORNER	(acs_map['m'])	/* lower left corner */
#define ACS_URCORNER	(acs_map['k'])	/* upper right corner */
#define ACS_LRCORNER	(acs_map['j'])	/* lower right corner */
#define ACS_LTEE	(acs_map['t'])	/* tee pointing right */
#define ACS_RTEE	(acs_map['u'])	/* tee pointing left */
#define ACS_BTEE	(acs_map['v'])	/* tee pointing up */
#define ACS_TTEE	(acs_map['w'])	/* tee pointing down */
#define ACS_HLINE	(acs_map['q'])	/* horizontal line */
#define ACS_VLINE	(acs_map['x'])	/* vertical line */
#define ACS_PLUS	(acs_map['n'])	/* large plus or crossover */
#define ACS_S1		(acs_map['o'])	/* scan line 1 */
#define ACS_S9		(acs_map['s'])	/* scan line 9 */
#define ACS_DIAMOND	(acs_map['`'])	/* diamond */
#define ACS_CKBOARD	(acs_map['a'])	/* checker board (stipple) */
#define ACS_DEGREE	(acs_map['f'])	/* degree symbol */
#define ACS_PLMINUS	(acs_map['g'])	/* plus/minus */
#define ACS_BULLET	(acs_map['~'])	/* bullet */
/* Teletype 5410v1 symbols begin here */
#define ACS_LARROW	(acs_map[','])	/* arrow pointing left */
#define ACS_RARROW	(acs_map['+'])	/* arrow pointing right */
#define ACS_DARROW	(acs_map['.'])	/* arrow pointing down */
#define ACS_UARROW	(acs_map['-'])	/* arrow pointing up */
#define ACS_BOARD	(acs_map['h'])	/* board of squares */
#define ACS_LANTERN	(acs_map['I'])	/* lantern symbol */
#define ACS_BLOCK	(acs_map['0'])	/* solid square block */
/*
 * These aren't documented, but a lot of System Vs have them anyway
 * (you can spot pprryyzz{{||}} in a lot of AT&T terminfo strings).
 * The ACS_names may not match AT&T's, our source didn't know them.
 */
#define ACS_S3		(acs_map['p'])	/* scan line 3 */
#define ACS_S7		(acs_map['r'])	/* scan line 7 */
#define ACS_LEQUAL	(acs_map['y'])	/* less/equal */
#define ACS_GEQUAL	(acs_map['z'])	/* greater/equal */
#define ACS_PI		(acs_map['{'])	/* Pi */
#define ACS_NEQUAL	(acs_map['|'])	/* not equal */
#define ACS_STERLING	(acs_map['}'])	/* UK pound sign */

/*
 * Line drawing ACS names are of the form ACS_trbl, where t is the top, r
 * is the right, b is the bottom, and l is the left.  t, r, b, and l might
 * be B (blank), S (single), D (double), or T (thick).  The subset defined
 * here only uses B and S.
 */
#define ACS_BSSB	ACS_ULCORNER
#define ACS_SSBB	ACS_LLCORNER
#define ACS_BBSS	ACS_URCORNER
#define ACS_SBBS	ACS_LRCORNER
#define ACS_SBSS	ACS_RTEE
#define ACS_SSSB	ACS_LTEE
#define ACS_SSBS	ACS_BTEE
#define ACS_BSSS	ACS_TTEE
#define ACS_BSBS	ACS_HLINE
#define ACS_SBSB	ACS_VLINE
#define ACS_SSSS	ACS_PLUS

#if	!defined(ERR) || ((ERR) != -1)
#define ERR     (-1)
#endif

#if	!defined(OK) || ((OK) != 0)
#define OK      (0)
#endif

/* values for the _flags member */
#define _SUBWIN         0x01	/* is this a sub-window? */
#define _ENDLINE        0x02	/* is the window flush right? */
#define _FULLWIN        0x04	/* is the window full-screen? */
#define _SCROLLWIN      0x08	/* bottom edge is at screen bottom? */
#define _ISPAD	        0x10	/* is this window a pad? */
#define _HASMOVED       0x20	/* has cursor moved since last refresh? */
#define _WRAPPED        0x40	/* cursor was just wrappped */

/*
 * this value is used in the firstchar and lastchar fields to mark
 * unchanged lines
 */
#define _NOCHANGE       -1

/*
 * this value is used in the oldindex field to mark lines created by insertions
 * and scrolls.
 */
#define _NEWINDEX	-1

typedef struct screen  SCREEN;
typedef struct _win_st WINDOW;

typedef	chtype	attr_t;		/* ...must be at least as wide as chtype */

#ifdef _XOPEN_SOURCE_EXTENDED
#ifndef _WCHAR_T
typedef unsigned long wchar_t;
#endif /* _WCHAR_T */
#ifndef _WINT_T
typedef long int wint_t;
#endif /* _WINT_T */

#define CCHARW_MAX	5
typedef struct
{
    attr_t	attr;
    wchar_t	chars[CCHARW_MAX];
}
cchar_t;
#endif /* _XOPEN_SOURCE_EXTENDED */

struct _win_st {
	short   _cury, _curx;	/* current cursor position */

	/* window location and size */
	short   _maxy, _maxx;	/* maximums of x and y, NOT window size */
	short   _begy, _begx;	/* screen coords of upper-left-hand corner */

	short   _flags;		/* window state flags */

	/* attribute tracking */
	attr_t  _attrs;		/* current attribute for non-space character */
	chtype  _bkgd;		/* current background char/attribute pair */

	/* option values set by user */
	bool	_notimeout;	/* no time out on function-key entry? */
	bool    _clear;		/* consider all data in the window invalid? */
	bool    _leaveok;	/* OK to not reset cursor on exit? */
	bool    _scroll;	/* OK to scroll this window? */
	bool    _idlok;		/* OK to use insert/delete line? */
	bool    _idcok;		/* OK to use insert/delete char? */
	bool	_immed;		/* window in immed mode? (not yet used) */
	bool	_sync;		/* window in sync mode? */
	bool    _use_keypad;    /* process function keys into KEY_ symbols? */
	int	_delay;		/* 0 = nodelay, <0 = blocking, >0 = delay */

	/* the actual line data */
	struct ldat
	{
	    chtype  *text;	/* text of the line */
	    short   firstchar;  /* first changed character in the line */
	    short   lastchar;   /* last changed character in the line */
	    short   oldindex;	/* index of the line at last update */
	}
	*_line;

	/* global screen state */
	short	_regtop;	/* top line of scrolling region */
	short	_regbottom;	/* bottom line of scrolling region */

	/* these are used only if this is a sub-window */
	int	_parx;		/* x coordinate of this window in parent */
	int	_pary;		/* y coordinate of this window in parent */
	WINDOW	*_parent;	/* pointer to parent if a sub-window */

	/* these are used only if this is a pad */
	struct pdat
	{
	    short _pad_y,      _pad_x;
	    short _pad_top,    _pad_left;
	    short _pad_bottom, _pad_right;
	} _pad;

	short   _yoffset;	/* real begy is _begy + _yoffset */
};

extern WINDOW   *stdscr, *curscr, *newscr;

extern int	LINES, COLS, TABSIZE;

/*
 * This global was an undocumented feature under AIX curses.
 */
extern int ESCDELAY;	/* ESC expire time in milliseconds */

/* non-XSI extensions (dickey@clark.net) */
extern int resizeterm (int, int);
extern int wresize (WINDOW *, int, int); 

extern char ttytype[];		/* needed for backward compatibility */

/*
 * GCC (and some other compilers) define '__attribute__'; we're using this
 * macro to alert the compiler to flag inconsistencies in printf/scanf-like
 * function calls.  Just in case '__attribute__' isn't defined, make a dummy.
 */
#if !defined(__GNUC__) && !defined(__attribute__)
#define __attribute__(p) /* nothing */
#endif

/*
 * We cannot define these in config.h, since they require parameters to be
 * passed (that's non-portable).
 */
#if	GCC_PRINTF
#define GCC_PRINTFLIKE(fmt,var) __attribute__((format(printf,fmt,var)))
#else
#define GCC_PRINTFLIKE(fmt,var) /*nothing*/
#endif

#if	GCC_SCANF
#define GCC_SCANFLIKE(fmt,var)  __attribute__((format(scanf,fmt,var)))
#else
#define GCC_SCANFLIKE(fmt,var)  /*nothing*/
#endif

#ifndef	GCC_NORETURN
#define	GCC_NORETURN /* nothing */
#endif

#ifndef	GCC_UNUSED
#define	GCC_UNUSED /* nothing */
#endif

/*
 * Function prototypes.  This is the complete XSI Curses list of required
 * functions.  Those marked `generated' will have sources generated from the
 * macro definitions later in this file, in order to satisfy XPG4.2
 * requirements.
 */

extern int addch(const chtype);				/* generated */
extern int addchnstr(const chtype *, int);		/* generated */
extern int addchstr(const chtype *);			/* generated */
extern int addnstr(const char *, int);			/* generated */
extern int addstr(const char *);			/* generated */
#ifdef _XOPEN_SOURCE_EXTENDED
extern int addnwstr(const wchar_t *, int);		/* missing */
extern int addwstr(const wchar_t *);			/* missing */
extern int add_wch(const cchar_t *);			/* missing */
extern int add_wchnstr(const cchar_t *, int);		/* missing */
extern int add_wchstr(const cchar_t *);			/* missing */
#endif /* _XOPEN_SOURCE_EXTENDED */
extern int attroff(int);				/* generated */
extern int attron(int);					/* generated */
extern int attrset(int);				/* generated */
extern int attr_get(void);				/* generated */
extern int attr_off(int);				/* generated */
extern int attr_on(int);				/* generated */
extern int attr_set(int);				/* generated */
extern int baudrate(void);				/* implemented */
extern int beep(void);					/* implemented */
extern int bkgd(chtype);				/* generated */
extern void bkgdset(chtype);				/* generated */
#ifdef _XOPEN_SOURCE_EXTENDED
extern int bkgrndset(const cchar_t *);			/* missing */
extern int bkgrnd(const cchar_t *);			/* missing */
#endif /* _XOPEN_SOURCE_EXTENDED */
extern int border(chtype,chtype,chtype,chtype,chtype,chtype,chtype,chtype);	/* generated */
#ifdef _XOPEN_SOURCE_EXTENDED
extern int border_set(cchar_t,cchar_t,cchar_t,cchar_t,cchar_t,cchar_t,cchar_t,cchar_t);	/* missing */
#endif /* _XOPEN_SOURCE_EXTENDED */
extern int box(WINDOW *, chtype, chtype);		/* generated */
#ifdef _XOPEN_SOURCE_EXTENDED
extern int box_set(WINDOW *, cchar_t, cchar_t);		/* missing */
#endif /* _XOPEN_SOURCE_EXTENDED */
extern bool can_change_color(void);			/* implemented */
extern int cbreak(void);				/* implemented */
extern int chgat(int, attr_t, short, const void *);	/* generated */
extern int clear(void);					/* generated */
extern int clearok(WINDOW *,bool);			/* implemented */
extern int clrtobot(void);				/* generated */
extern int clrtoeol(void);				/* generated */
extern int color_content(short,short*,short*,short*);	/* implemented */
extern int COLOR_PAIR(int);				/* generated */
extern int copywin(const WINDOW*,WINDOW*,int,int,int,int,int,int,int);	/* implemented */
extern int curs_set(int);				/* implemented */
extern int def_prog_mode(void);				/* implemented */
extern int def_shell_mode(void);			/* implemented */
extern int delay_output(int);				/* implemented */
extern int delch(void);					/* generated */
extern void delscreen(SCREEN *);			/* implemented */
extern int delwin(WINDOW *);				/* implemented */
extern int deleteln(void);				/* generated */
extern WINDOW *derwin(WINDOW *,int,int,int,int);	/* implemented */
extern int doupdate(void);				/* implemented */
extern WINDOW *dupwin(WINDOW *);			/* implemented */
extern int echo(void);					/* implemented */
extern int echochar(const chtype);			/* generated */
#ifdef _XOPEN_SOURCE_EXTENDED
extern int echo_wchar(const cchar_t *);			/* missing */
#endif /* _XOPEN_SOURCE_EXTENDED */
extern int endwin(void);				/* implemented */
extern char erasechar(void);				/* implemented */
#ifdef _XOPEN_SOURCE_EXTENDED
extern int erase_wchar(wchar_t *);			/* missing */
#endif /* _XOPEN_SOURCE_EXTENDED */
extern void filter(void);				/* implemented */
extern int flash(void);					/* implemented */
extern int flushinp(void);				/* implemented */
extern chtype getbkgd(WINDOW *);			/* generated */
#ifdef _XOPEN_SOURCE_EXTENDED
extern int getbkgrnd(cchar_t *);			/* missing */
extern int getcchar(const cchar_t *, wchar_t*, attr_t*, short*, void*);	/* missing */
#endif /* _XOPEN_SOURCE_EXTENDED */
extern int getch(void);					/* generated */
extern int getnstr(char *, int);			/* generated */
#ifdef _XOPEN_SOURCE_EXTENDED
extern int getn_wstr(wint_t *, int);			/* missing */
#endif /* _XOPEN_SOURCE_EXTENDED */
extern int getstr(char *);				/* generated */
#ifdef _XOPEN_SOURCE_EXTENDED
extern int get_wch(wint_t *);				/* missing */
#endif /* _XOPEN_SOURCE_EXTENDED */
extern WINDOW *getwin(FILE *);				/* not in XPG4 */
#ifdef _XOPEN_SOURCE_EXTENDED
extern int get_wstr(wint_t *);				/* missing */
#endif /* _XOPEN_SOURCE_EXTENDED */
extern int halfdelay(int);				/* implemented */
extern bool has_colors(void);				/* implemented */
extern int has_ic(void);				/* implemented */
extern int has_il(void);				/* implemented */
extern int hline(chtype, int);				/* generated */
#ifdef _XOPEN_SOURCE_EXTENDED
extern int hline_set(const cchar_t *, int);		/* missing */
#endif /* _XOPEN_SOURCE_EXTENDED */
extern void idcok(WINDOW *, bool);			/* implemented */
extern int idlok(WINDOW *, bool);			/* implemented */
extern void immedok(WINDOW *, bool);			/* implemented */
extern chtype inch(void);				/* generated */
extern int inchnstr(chtype *, int);			/* generated */
extern int inchstr(chtype *);				/* generated */
extern WINDOW *initscr(void);				/* implemented */
extern int init_color(short,short,short,short);		/* implemented */
extern int init_pair(short,short,short);		/* implemented */
extern int innstr(char *, int);				/* generated */
#ifdef _XOPEN_SOURCE_EXTENDED
extern int innwstr(wchar_t *, int);			/* missing */
#endif /* _XOPEN_SOURCE_EXTENDED */
extern int insch(chtype);				/* generated */
extern int insdelln(int);				/* generated */
extern int insertln(void);				/* generated */
extern int insnstr(const char *, int);			/* generated */
extern int insstr(const char *);			/* generated */
extern int instr(char *);				/* generated */
#ifdef _XOPEN_SOURCE_EXTENDED
extern int ins_nwstr(const wchar_t *, int);		/* missing */
extern int ins_wch(const cchar_t *);			/* missing */
extern int ins_wstr(const wchar_t *);			/* missing */
#endif /* _XOPEN_SOURCE_EXTENDED */
extern int intrflush(WINDOW *,bool);			/* implemented */
#ifdef _XOPEN_SOURCE_EXTENDED
extern int inwstr(wchar_t *);				/* missing */
extern int in_wch(const cchar_t *);			/* missing */
extern int in_wchstr(const cchar_t *);			/* missing */
extern int in_wchntr(const cchar_t *, int);		/* missing */
#endif /* _XOPEN_SOURCE_EXTENDED */
extern int isendwin(void);				/* implemented */
extern int is_linetouched(WINDOW *,int);		/* implemented */
extern int is_wintouched(WINDOW *);			/* implemented */
extern const char *keyname(int);			/* implemented */
#ifdef _XOPEN_SOURCE_EXTENDED
extern int key_name(wchar_t *);				/* missing */
#endif /* _XOPEN_SOURCE_EXTENDED */
extern int keypad(WINDOW *,bool);			/* implemented */
extern char killchar(void);				/* implemented */
#ifdef _XOPEN_SOURCE_EXTENDED
extern int killwchar(wchar_t *);			/* missing */
#endif /* _XOPEN_SOURCE_EXTENDED */
extern int leaveok(WINDOW *,bool);			/* implemented */
extern char *longname(void);				/* implemented */
extern int meta(WINDOW *,bool);				/* implemented */
extern int move(int, int);				/* generated */
extern int mvaddch(int, int, const chtype);		/* generated */
extern int mvaddchnstr(int, int, const chtype *, int);	/* generated */
extern int mvaddchstr(int, int, const chtype *);	/* generated */
extern int mvaddnstr(int, int, const char *, int);	/* generated */
extern int mvaddstr(int, int, const char *);		/* generated */
#ifdef _XOPEN_SOURCE_EXTENDED
extern int mvaddnwstr(int, int, const wchar_t *, int);	/* missing */
extern int mvaddwstr(int, int, const wchar_t *);	/* missing */
extern int mvadd_wch(int, int, const cchar_t *);	/* missing */
extern int mvadd_wchnstr(int, int, const cchar_t *, int);/* missing */
extern int mvadd_wchstr(int, int, const cchar_t *);	/* missing */
#endif /* _XOPEN_SOURCE_EXTENDED */
extern int mvchgat(int, int, int, attr_t, short, const void *);	/* generated */
extern int mvcur(int,int,int,int);			/* implemented */
extern int mvdelch(int, int);				/* generated */
extern int mvderwin(WINDOW *, int, int);		/* implemented */
extern int mvgetch(int, int);				/* generated */
extern int mvgetnstr(int, int, char *, int);		/* generated */
#ifdef _XOPEN_SOURCE_EXTENDED
extern int mvgetn_wstr(int, int, wint_t *, int);	/* missing */
#endif /* _XOPEN_SOURCE_EXTENDED */
extern int mvgetstr(int, int, char *);			/* generated */
#ifdef _XOPEN_SOURCE_EXTENDED
extern int mvget_wch(int, int, wint_t *);		/* missing */
#endif /* _XOPEN_SOURCE_EXTENDED */
#ifdef _XOPEN_SOURCE_EXTENDED
extern int mvget_wstr(int, int, wint_t *);		/* missing */
#endif /* _XOPEN_SOURCE_EXTENDED */
extern int mvhline(int, int, chtype, int);		/* generated */
#ifdef _XOPEN_SOURCE_EXTENDED
extern int mvhline_set(int, int, const cchar_t *, int);	/* missing */
#endif /* _XOPEN_SOURCE_EXTENDED */
extern chtype mvinch(int, int);				/* generated */
extern int mvinchnstr(int, int, chtype *, int);		/* generated */
extern int mvinchstr(int, int, chtype *);		/* generated */
extern int mvinnstr(int, int, char *, int);		/* generated */
#ifdef _XOPEN_SOURCE_EXTENDED
extern int mvinnwstr(int, int, wchar_t *, int);		/* missing */
#endif /* _XOPEN_SOURCE_EXTENDED */
extern int mvinsch(int, int, chtype);			/* generated */
extern int mvinsnstr(int, int, const char *, int);	/* generated */
extern int mvinsstr(int, int, const char *);		/* generated */
extern int mvinstr(int, int, char *);			/* generated */
#ifdef _XOPEN_SOURCE_EXTENDED
extern int mvins_nwstr(int, int, const wchar_t *, int);	/* missing */
extern int mvins_wch(int, int, const cchar_t *);	/* missing */
extern int mvins_wstr(int, int, const wchar_t *);	/* missing */
extern int mvinwstr(int, int, wchar_t *);		/* missing */
extern int mvin_wch(int, int, const cchar_t *);		/* missing */
extern int mvin_wchstr(int, int, const cchar_t *);	/* missing */
extern int mvin_wchntr(int, int, const cchar_t *, int);	/* missing */
#endif /* _XOPEN_SOURCE_EXTENDED */
extern int mvprintw(int,int,const char *,...)		/* implemented */
		GCC_PRINTFLIKE(3,4);
extern int mvscanw(int,int,const char *,...)		/* implemented */
		GCC_SCANFLIKE(3,4);
extern int mvvline(int, int, chtype, int);		/* generated */
#ifdef _XOPEN_SOURCE_EXTENDED
extern int mvvline_set(int, int, const cchar_t *, int);	/* missing */
#endif /* _XOPEN_SOURCE_EXTENDED */
extern int mvwaddch(WINDOW *, int, int, const chtype);	/* generated */
extern int mvwaddchnstr(WINDOW *, int, int, const chtype *, int);/* generated */
extern int mvwaddchstr(WINDOW *, int, int, const chtype *);	/* generated */
extern int mvwaddnstr(WINDOW *, int, int, const char *, int);	/* generated */
extern int mvwaddstr(WINDOW *, int, int, const char *);	/* generated */
#ifdef _XOPEN_SOURCE_EXTENDED
extern int mvwaddnwstr(WINDOW *, int, int, const wchar_t *, int);/* missing */
extern int mvwaddwstr(WINDOW *, int, int, const wchar_t *);	/* missing */
extern int mvwadd_wch(WINDOW *, int, int, const cchar_t *);	/* missing */
extern int mvwadd_wchnstr(WINDOW *, int, int, const cchar_t *, int); /* missing */
extern int mvwadd_wchstr(WINDOW *, int, int, const cchar_t *);	/* missing */
#endif /* _XOPEN_SOURCE_EXTENDED */
extern int mvwchgat(WINDOW *, int, int, int, attr_t, short, const void *);/* generated */
extern int mvwdelch(WINDOW *, int, int);		/* generated */
extern int mvwgetch(WINDOW *, int, int);		/* generated */
extern int mvwgetnstr(WINDOW *, int, int, char *, int);	/* generated */
#ifdef _XOPEN_SOURCE_EXTENDED
extern int mvwgetn_wstr(WINDOW *, int, int, wint_t *, int);/* missing */
#endif /* _XOPEN_SOURCE_EXTENDED */
extern int mvwgetstr(WINDOW *, int, int, char *);	/* generated */
#ifdef _XOPEN_SOURCE_EXTENDED
extern int mvwget_wch(WINDOW *, int, int, wint_t *);	/* missing */
#endif /* _XOPEN_SOURCE_EXTENDED */
#ifdef _XOPEN_SOURCE_EXTENDED
extern int mvwget_wstr(WINDOW *, int, int, wint_t *);	/* missing */
#endif /* _XOPEN_SOURCE_EXTENDED */
extern int mvwhline(WINDOW *, int, int, chtype, int);	/* generated */
#ifdef _XOPEN_SOURCE_EXTENDED
extern int mvwhline_set(WINDOW *, int, int, const cchar_t *, int);/* missing */
#endif /* _XOPEN_SOURCE_EXTENDED */
extern int mvwin(WINDOW *,int,int);			/* implemented */
extern chtype mvwinch(WINDOW *, int, int);			/* generated */
extern int mvwinchnstr(WINDOW *, int, int, chtype *, int);	/* generated */
extern int mvwinchstr(WINDOW *, int, int, chtype *);		/* generated */
extern int mvwinnstr(WINDOW *, int, int, char *, int);		/* generated */
#ifdef _XOPEN_SOURCE_EXTENDED
extern int mvwinnwstr(WINDOW *, int, int, wchar_t *, int);	/* missing */
#endif /* _XOPEN_SOURCE_EXTENDED */
extern int mvwinsch(WINDOW *, int, int, chtype);		/* generated */
extern int mvwinsnstr(WINDOW *, int, int, const char *, int);	/* generated */
extern int mvwinsstr(WINDOW *, int, int, const char *);		/* generated */
extern int mvwinstr(WINDOW *, int, int, char *);		/* generated */
#ifdef _XOPEN_SOURCE_EXTENDED
extern int mvwins_nwstr(WINDOW *, int,int, const wchar_t *,int); /* missing */
extern int mvwins_wch(WINDOW *, int, int, const cchar_t *);	/* missing */
extern int mvwins_wstr(WINDOW *, int, int, const wchar_t *);	/* missing */
extern int mvwinwstr(WINDOW *, int, int, wchar_t *);		/* missing */
extern int mvwin_wch(WINDOW *, int, int, const cchar_t *);	/* missing */
extern int mvwin_wchnstr(WINDOW *, int,int,const cchar_t *,int); /* missing */
extern int mvwin_wchstr(WINDOW *, int, int, const cchar_t *);	/* missing */
#endif /* _XOPEN_SOURCE_EXTENDED */
extern int mvwprintw(WINDOW*,int,int,const char *,...)	/* implemented */
		GCC_PRINTFLIKE(4,5);
extern int mvwscanw(WINDOW *,int,int,const char *,...)	/* implemented */
		GCC_SCANFLIKE(4,5);
extern int mvwvline(WINDOW *,int, int, chtype, int);	/* generated */
#ifdef _XOPEN_SOURCE_EXTENDED
extern int mvwvline_set(WINDOW *, int,int, const cchar_t *,int); /* missing */
#endif /* _XOPEN_SOURCE_EXTENDED */
extern int napms(int);					/* implemented */
extern WINDOW *newpad(int,int);				/* implemented */
extern SCREEN *newterm(const char *,FILE *,FILE *);	/* implemented */
extern WINDOW *newwin(int,int,int,int);			/* implemented */
extern int nl(void);					/* implemented */
extern int nocbreak(void);				/* implemented */
extern int nodelay(WINDOW *,bool);			/* implemented */
extern int noecho(void);				/* implemented */
extern int nonl(void);					/* implemented */
extern int noqiflush(void);				/* implemented */
extern int noraw(void);					/* implemented */
extern int notimeout(WINDOW *,bool);			/* implemented */
extern int overlay(const WINDOW*,WINDOW *);		/* implemented */
extern int overwrite(const WINDOW*,WINDOW *);		/* implemented */
extern int pair_content(short,short*,short*);		/* implemented */
extern int PAIR_NUMBER(int);				/* generated */
extern int pechochar(WINDOW *, chtype);			/* implemented */
#ifdef _XOPEN_SOURCE_EXTENDED
extern int pecho_wchar(WINDOW *, const cchar_t *);	/* missing */
#endif /* _XOPEN_SOURCE_EXTENDED */
extern int pnoutrefresh(WINDOW*,int,int,int,int,int,int);/* implemented */
extern int prefresh(WINDOW *,int,int,int,int,int,int);	/* implemented */
extern int printw(const char *,...)			/* implemented */
		GCC_PRINTFLIKE(1,2);
extern int putp(const char *);				/* implemented */
extern int putwin(WINDOW *, FILE *);			/* implemented */
extern int qiflush(void);				/* implemented */
extern int raw(void);					/* implemented */
extern int redrawwin(WINDOW *);				/* generated */
extern int refresh(void);				/* generated */
extern int resetty(void);				/* implemented */
extern int reset_prog_mode(void);			/* implemented */
extern int reset_shell_mode(void);			/* implemented */
extern int ripoffline(int, int (*init)(WINDOW *, int));	/* implemented */
extern int savetty(void);				/* implemented */
extern int scanw(const char *,...)			/* implemented */
		GCC_SCANFLIKE(1,2);
extern int scr_dump(const char *);			/* implemented */
extern int scr_init(const char *);			/* implemented */
extern int scrl(int);					/* generated */
extern int scroll(WINDOW *);				/* generated */
extern int scrollok(WINDOW *,bool);			/* implemented */
extern int scr_restore(const char *);			/* implemented */
extern int scr_set(const char *);			/* implemented */
#ifdef _XOPEN_SOURCE_EXTENDED
extern int setcchar(cchar_t *, wchar_t *, attr_t, short, const void *);	/* missing */
#endif /* _XOPEN_SOURCE_EXTENDED */
extern int setscrreg(int,int);				/* generated */
extern SCREEN *set_term(SCREEN *);			/* implemented */
extern int slk_attroff(const attr_t);			/* implemented */
#ifdef _XOPEN_SOURCE_EXTENDED
extern int slk_attr_off(attr_t);			/* missing */
#endif /* _XOPEN_SOURCE_EXTENDED */
extern int slk_attron(const attr_t);			/* implemented */
#ifdef _XOPEN_SOURCE_EXTENDED
extern int slk_attr_on(attr_t);				/* missing */
#endif /* _XOPEN_SOURCE_EXTENDED */
extern int slk_attrset(const attr_t);			/* implemented */
extern attr_t slk_attr(void);                           /* implemented */
#ifdef _XOPEN_SOURCE_EXTENDED
extern int slk_attr_set(attr_t);			/* missing */
#endif /* _XOPEN_SOURCE_EXTENDED */
extern int slk_clear(void);				/* implemented */
extern int slk_init(int);				/* implemented */
extern char *slk_label(int);				/* implemented */
extern int slk_noutrefresh(void);			/* implemented */
extern int slk_refresh(void);				/* implemented */
extern int slk_restore(void);				/* implemented */
extern int slk_set(int,const char *,int);		/* implemented */
extern int slk_touch(void);				/* implemented */
#ifdef _XOPEN_SOURCE_EXTENDED
extern int slk_wset(int, wchar_t *, int);		/* missing */
#endif /* _XOPEN_SOURCE_EXTENDED */
extern int standout(void);				/* generated */
extern int standend(void);				/* generated */
extern int start_color(void);				/* implemented */
extern WINDOW *subpad(WINDOW *, int, int, int, int);	/* implemented */
extern WINDOW *subwin(WINDOW *,int,int,int,int);	/* implemented */
extern int syncok(WINDOW *, bool);			/* implemented */
extern attr_t termattrs(void);				/* implemented */
extern char *termname(void);				/* implemented */
extern int tigetflag(const char *);			/* implemented */
extern int tigetnum(const char *);			/* implemented */
extern char *tigetstr(const char *);			/* implemented */
extern int timeout(int);				/* generated */
extern int typeahead(int);				/* implemented */
extern int ungetch(int);				/* implemented */
#ifdef _XOPEN_SOURCE_EXTENDED
extern int unget_wch(const wchar_t *);			/* missing */
#endif /* _XOPEN_SOURCE_EXTENDED */
extern int untouchwin(WINDOW *);			/* generated */
extern void use_env(bool);				/* implemented */
extern int vidattr(chtype);				/* implemented */
#ifdef _XOPEN_SOURCE_EXTENDED
extern int vid_attr(attr_t);				/* missing */
#endif /* _XOPEN_SOURCE_EXTENDED */
extern int vidputs(chtype, int (*)(int));		/* implemented */
#ifdef _XOPEN_SOURCE_EXTENDED
extern int vid_puts(attr_t, int (*)(int));		/* missing */
#endif /* _XOPEN_SOURCE_EXTENDED */
extern int vline(chtype, int);				/* generated */
#ifdef _XOPEN_SOURCE_EXTENDED
extern int vline_set(const cchar_t *, int);		/* missing */
#endif /* _XOPEN_SOURCE_EXTENDED */
extern int vwprintw(WINDOW *,const char *,va_list);	/* implemented */
extern int vw_printw(WINDOW *,const char *,va_list);	/* generated */
extern int vwscanw(WINDOW *,const char *,va_list);	/* implemented */
extern int vw_scanw(WINDOW *,const char *,va_list);	/* generated */
extern int waddch(WINDOW *, const chtype);		/* implemented */
extern int waddchnstr(WINDOW *,const chtype *const,int); /* implemented */
extern int waddchstr(WINDOW *,const chtype *);		/* generated */
extern int waddnstr(WINDOW *,const char *const,int);	/* implemented */
extern int waddstr(WINDOW *,const char *);		/* generated */
#ifdef _XOPEN_SOURCE_EXTENDED
extern int waddwstr(WINDOW *,const wchar_t *);		/* missing */
extern int wadd_wch(WINDOW *,const cchar_t *);		/* missing */
extern int wadd_wchnstr(WINDOW *,const cchar_t *,int);	/* missing */
extern int wadd_wchstr(WINDOW *,const cchar_t *);	/* missing */
#endif /* _XOPEN_SOURCE_EXTENDED */
extern int wattron(WINDOW *, int);			/* generated */
extern int wattroff(WINDOW *, int);			/* generated */
extern int wattrset(WINDOW *, int);			/* generated */
extern attr_t wattr_get(WINDOW *);			/* generated */
extern int wattr_on(WINDOW *, const attr_t);		/* implemented */
extern int wattr_off(WINDOW *, const attr_t);		/* implemented */
extern int wattr_set(WINDOW *, attr_t);			/* generated */
extern int wbkgd(WINDOW *,const chtype);		/* implemented */
extern void wbkgdset(WINDOW *,chtype);			/* generated */
#ifdef _XOPEN_SOURCE_EXTENDED
extern int wbkgrndset(WINDOW *,const cchar_t *);	/* missing */
extern int wbkgrnd(WINDOW *,const cchar_t *);		/* missing */
#endif /* _XOPEN_SOURCE_EXTENDED */
extern int wborder(WINDOW *,chtype,chtype,chtype,chtype,chtype,chtype,chtype,chtype);	/* implemented */
#ifdef _XOPEN_SOURCE_EXTENDED
extern int wborder_set(WINDOW *,cchar_t,cchar_t,cchar_t,cchar_t,cchar_t,cchar_t,cchar_t,cchar_t);	/* missing */
#endif /* _XOPEN_SOURCE_EXTENDED */
extern int wchgat(WINDOW *, int, attr_t, short, const void *);/* implemented */
extern int wclear(WINDOW *);				/* implemented */
extern int wclrtobot(WINDOW *);				/* implemented */
extern int wclrtoeol(WINDOW *);				/* implemented */
extern void wcursyncup(WINDOW *);			/* implemented */
extern int wdelch(WINDOW *);				/* implemented */
extern int wdeleteln(WINDOW *);				/* generated */
extern int wechochar(WINDOW *, const chtype);		/* implemented */
#ifdef _XOPEN_SOURCE_EXTENDED
extern int wecho_wchar(WINDOW *, const cchar_t *);	/* missing */
#endif /* _XOPEN_SOURCE_EXTENDED */
extern int werase(WINDOW *);				/* implemented */
#ifdef _XOPEN_SOURCE_EXTENDED
extern int wgetbkgrnd(WINDOW *, cchar_t *);		/* missing */
#endif /* _XOPEN_SOURCE_EXTENDED */
extern int wgetch(WINDOW *);				/* implemented */
extern int wgetnstr(WINDOW *,char *,int);		/* implemented */
#ifdef _XOPEN_SOURCE_EXTENDED
extern int wgetn_wstr(WINDOW *,wint_t *, int);		/* missing */
#endif /* _XOPEN_SOURCE_EXTENDED */
extern int wgetstr(WINDOW *, char *);			/* generated */
#ifdef _XOPEN_SOURCE_EXTENDED
extern int wget_wch(WINDOW *, wint_t *);		/* missing */
extern int wget_wstr(WINDOW *, wint_t *);		/* missing */
#endif /* _XOPEN_SOURCE_EXTENDED */
extern int whline(WINDOW *, chtype, int);		/* implemented */
#ifdef _XOPEN_SOURCE_EXTENDED
extern int whline_set(WINDOW *, const cchar_t *, int);	/* missing */
#endif /* _XOPEN_SOURCE_EXTENDED */
extern chtype winch(WINDOW *);				/* generated */
extern int winchnstr(WINDOW *, chtype *, int);		/* implemented */
extern int winchstr(WINDOW *, chtype *);		/* generated */
extern int winnstr(WINDOW *, char *, int);		/* implemented */
#ifdef _XOPEN_SOURCE_EXTENDED
extern int winnwstr(WINDOW *, wchar_t *, int);		/* missing */
#endif /* _XOPEN_SOURCE_EXTENDED */
extern int winsch(WINDOW *, chtype);			/* implemented */
extern int winsdelln(WINDOW *,int);			/* implemented */
extern int winsertln(WINDOW *);				/* generated */
extern int winsnstr(WINDOW *, const char *,int);	/* implemented */
extern int winsstr(WINDOW *, const char *);		/* generated */
extern int winstr(WINDOW *, char *);			/* generated */
#ifdef _XOPEN_SOURCE_EXTENDED
extern int wins_nwstr(WINDOW *, const wchar_t *, int);	/* missing */
extern int wins_wch(WINDOW *, const cchar_t *);		/* missing */
extern int wins_wstr(WINDOW *, const wchar_t *);	/* missing */
extern int winwstr(WINDOW *, wchar_t *);		/* missing */
extern int win_wch(WINDOW *, const cchar_t *);		/* missing */
extern int win_wchnstr(WINDOW *, const cchar_t *, int);	/* missing */
extern int win_wchstr(WINDOW *, const cchar_t *);	/* missing */
#endif /* _XOPEN_SOURCE_EXTENDED */
extern int wmove(WINDOW *,int,int);			/* implemented */
extern int wnoutrefresh(WINDOW *);			/* implemented */
extern int wprintw(WINDOW *,const char *,...)		/* implemented */
		GCC_PRINTFLIKE(2,24;_nbuf:54=ar1;0;0;11,536,8;_lb:41,544,64;_blksize:1,608,32;_offset:3,640,32;; FILE:t43 try:T55=s12child:56=*55,0,32;sibling:56,32,32;ch:11,64,8;value:9,80,16;; slk_ent:t57=s16text:32,0,32;form_text:32,32,32;x:1,64,32;dirty:2,96,8;visible:2,104,8;; SLK:t58=s24dirty:2,0,8;hidden:2,8,8;win:59=*60,32,32;ent:61=*57,64,32;buffer:32,96,32;maxlab:8,128,16;labcnt:8,144,16;maxlen:8,160,16;; color_t:t62=s6red:8,0,16;green:8,16,16;blue:8,32,16;; screen:T63=s488_ifd:1,0,32;_ofp:64=*43,32,32;_checkfd:1,64,32;_term:65=*66,96,32;_lines:8,128,16;_columns:8,144,16;_lines_avail:8,160,16;_topstolen:8,176,16;_curscr:59,192,32;_newscr:59,224,32;_stdscr:59,256,32;_keytry:56,288,32;_fifo:67=ar1;0;65;4,320,2112;_fifohead:10,2432,8;_fifotail:10,2440,8;_fifopeek:10,2448,8;_endwin:1,2464,32;_current_attr:5,2496,32;_coloron:1,2528,32;_cursor:1,2560,32;_cursrow:1,2592,32;_curscol:1,2624,32;_nl:1,2656,32;_raw:1,2688,32;_cbreak:1,2720,32;_echo:1,2752,32;_use_meta:1,2784,32;_slk:68=*58,2816,32;_baudrate:1,2848,32;_char_padding:1,2880,32;_cr_cost:1,2912,32;_cup_cost:1,2944,32;_home_cost:1,2976,32;_ll_cost:1,3008,32;_cub1_cost:1,3040,32;_cuf1_cost:1,3072,32;_cud1_cost:1,3104,32;_cuu1_cost:1,3136,32;_cub_cost:1,3168,32;_cuf_cost:1,3200,32;_cud_cost:1,3232,32;_cuu_cost:1,3264,32;_hpa_cost:1,3296,32;_vpa_cost:1,3328,32;_ed_cost:1,3360,32;_el_cost:1,3392,32;_el1_cost:1,3424,32;_dch1_cost:1,3456,32;_ich1_cost:1,3488,32;_dch_cost:1,3520,32;_ich_cost:1,3552,32;_ech_cost:1,3584,32;_rep_cost:1,3616,32;_address_cursor:32,3648,32;_carriage_return_length:1,3680,32;_cursor_home_length:1,3712,32;_cursor_to_ll_length:1,3744,32;_color_table:69=*62,3776,32;_color_count:1,3808,32;_color_pairs:42,3840,32;_pair_count:1,3872,32;; chtype:t5 va_list:t32 __gnuc_va_list:t32 bool:t4 SCREEN:t63 WINDOW:t60 attr_t:t5 ldat:T70=s12text:71=*5,0,32;firstchar:8,32,16;lastchar:8,48,16;oldindex:8,64,16;; pdat:T72=s12_pad_y:8,0,16;_pad_x:8,16,16;_pad_top:8,32,16;_pad_left:8,48,16;_pad_bottom:8,64,16;_pad_right:8,80,16;; _win_st:T48=s100_cury:8,0,16;_curx:8,16,16;_maxy:8,32,16;_bf:41,128,64;_lbfsize:1,192,32;_cookie:44=*19,224,32;_close:45=*46=f1,256,32;_read:47=*48=f1,288,32;_seek:49=*50=f3,320,32;_write:51=*52=f1,352,32;_ub:41,384,64;_up:42,448,32;_ur:1,480,32;_ubuf:53=ar1;0;2;11,512,24;_nbuf:54=ar1;0;0;11,536,8;_lb:41,544,64;_blksize:1,608,32;_offset:3,640,32;; FILE:t43 try:T55=s12child:56=*55,0,32;sibling:56,32,32;ch:11,64,8;value:9,80,16;; slk_ent:t57=s16text:32,0,32;form_text:32,32,32;x:1,64,32;dirty:2,96,8;visible:2,104,8;; SLK:t58=s24dirty:2,0,8;hidden:2,8,8;win:59=*60,32,32;ent:61=*57,64,32;buffer:32,96,32;maxlab:8,128,16;labcnt:8,144,16;maxlen:8,160,16;; color_t:t62=s6red:8,0,16;green:8,16,16;blue:8,32,16;; screen:T63=s488_ifd:1,0,32;_ofp:64=*43,32,32;_checkfd:1,64,32;_term:65=*66,96,32;_lines:8,128,16;_columns:8,144,16;_lines_avail:8,160,16;_topstolen:8,176,16;_curscr:59,192,32;_newscr:59,224,32;_stdscr:59,256,32;_keytry:56,288,32;_fifo:67=ar1;0;65;4,320,2112;_fifohead:10,2432,8;_fifotail:10,2440,8;_fifopeek:10,2448,8;_endwin:1,2464,32;_current_attr:5,2496,32;_coloron:1,2528,32;_cursor:1,2560,32;_cursrow:1,2592,32;_curscol:1,2624,32;_nl:1,2656,32;_raw:1,2688,32;_cbreak:1,2720,32;_echo:1,2752,32;_use_meta:1,2784,32;_slk:68=*58,2816,32;_baudrate:1,2848,32;_char_padding:1,2880,32;_cr_cost:1,2912,32;_cup_cost:1,2944,32;_home_cost:1,2976,32;_ll_cost:1,3008,32;_cub1_cost:1,3040,32;_cuf1_cost:1,3072,32;_cud1_cost:1,3104,32;_cuu1_cost:1,3136,32;_cub_cost:1,3168,32;_cuf_cost:1,3200,32;_cud_cost:1,3232,32;_cuu_cost:1,3264,32;_hpa_cost:1,3296,32;_vpa_cost:1,3328,32;_ed_cost:1,3360,32;_el_cost:1,3392,32;_el1_cost:1,3424,32;_dch1_cost:1,3456,32;_ich1_cost:1,3488,32;_dch_cost:1,3520,32;_ich_cost:1,3552,32;_ech_cost:1,3584,32;_rep_cost:1,3616,32;_address_cursor:32,3648,32;_carriage_return_length:1,3680,32;_cursor_home_length:1,3712,32;_cursor_to_ll_length:1,3744,32;_color_table:69=*62,3776,32;_color_count:1,3808,32;_color_pairs:42,3776,32;_color_count:1,3808,32;_color_pairs:42,3840,32;_pair_count:1,3872,32;; chtype:t5 va_list:t32 __gnuc_va_list:t32 bool:t4 SCREEN:t63 WINDOW:t60 attr_t:t5 ldat:T70=s12text:71=*5,0,32;firstchar:8,32,16;lastchar:8,48,16;oldindex:8,64,16;; pdat:T72=s12_pad_y:8,0,16;_pad_x:8,16,16;_pad_top:8,32,16;_pad_left:8,48,16;_pad_bottom:8,64,16;_pad_right:8,80,16;; _win_st:T60=s100_cury:8,0,16;_curx:8,16,16;_maxy:8,32,16;_maxx:8,48,16;_begy:8,64,16;_begx:8,80,16;_flags:8,96,16;_attrs:5,128,32;_bkgd:5,160,32;_notimeout:4,192,32;_clear:4,224,32;_leaveok:4,256,32;_scroll:4,288,32;_idlok:4,320,32;_idcok:4,352,32;_immed:4,384,32;_sync:4,416,32;_use_keypad:4,448,32;_delay:1,480,32;_line:73=*70,512,32;_regtop:8,544,16;_regbottom:8,560,16;_parx:1,576,32;_pary:1,608,32;_parent:74=*60,640,32;_pad:72,672,96;_yoffset:8,768,16;; mmask_t:t5 MEVENT:t75=s20id:8,0,16;x:1,32,32;y:1,64,32;z:1,96,32;bstate:5,128,32;; ripoff_t:t76=s12line:1,0,32;hook:77=*78=f1,32,32;w:59,64,32;; _wclrtoeol _.wclrtoeol __tracef __nc_background __nc_synchook __nc_tracing _._tracef _._nc_background _._nc_synchook wclrtoeol:F1 win:R74 maxx:r71 ptr:r71 end:r71 y:r8 x:r8 minx:r8 blank:r5 
lib_color.o     865106247   0     103   100644  13942     `
    
H                                                 x 2 d  2 d  2 dJ 2 d < 2 d, 2 d   2 dstart_color() called.   orig_pair   orig_colors started color: COLORS = %d, COLOR_PAIRS = %d  ١n @  D  J	  `"    s     pL( 
$(@ xD  0  C    t pL, 
$,@ D  0  C    t pL( ,      ê  p:S P u°  û  pKT# P@  T    1 p;#pJD N v a bD$b"C    0LA  C<pKc 4pJ % 
  0"   p\p\   "        dUE  dD @  D  , 
$,@ D  0  C    t @  D  J  0  3  @  D    "    s  ɡ   <ߨan tg i0h@k7 ?]kpH jk	 
jp
 [jf\>m~-m 0   \  &m  m  Y   1 d~=EbD$m #$ "EbD$#$m "5<   &'/ 	Hb $ ";?    " x b $ ";?   " b $ ";?  "hm"0h   6a  Thainit_pair( %d, %d, %d ) initializing pair: pair = %d, fg=(%d,%d,%d), bg=(%d,%d,%d)
 initialize_pair فn |j@@  D  h J k0s "  8K  Z (@  D  $ 	@  D   

  
  y @  D  4K @2C@  D  4 
a %     
 0  @  D  J KcD4c3<PCQSR*c"2c3<0P#1!Q#2!Rs "  3  8 ؐ  ͙  	4  )KcD4c3<PCQSR*tc"2c3<0P#1!Q#2!R331)4        8   u  Ɂ  T߈1  initialize_color  فn |j00  3  0h i@  AkP	=@  D  7 % 
 h -	  d '  d u @  D   %  b
 菰 	 菰 	 艰 #H T 0  3  pCTp3HlDl\ 0sd1c  P  U  %cD4c3b2 Ed4!0"@  D  0  80$0tJ|        Y   u  Ɂ  L߈An @  D  $ #"/   0n @  D  (   , 
  N 
 P 
< 
@ 
  
$ 8 
!   0ٱn o0kPR l@@  D  T cU     "  pBD5c3d4 pBDd4  pB0   ɱ   8߸An e0" 	o@@  D  $  0  3  pCDB@   pCDB@     01set_color_pair  setting colors: pair = %d, fg = %d, bg = %d
    set_a_foreground    set_foreground  set_a_background    set_background  ١n  k0@  D  (  s$(1P xU    _    d  |   ê  pJ8  t$8@lD   ^cub= >LM <@  D  J M >] <v |"    c pJ   
= >$ @D   
t$<t@D  P  E    s1  d @  D  $  
= <$$@D   
t$@t@D  P  E    s1  d ɡ  @ߨ!                               v                                          
d                                                                    
         zp     `     {     }p     `    p      &  `  .  p  4    V  }p  n  p    p        p        `    `    p       
  }p    `  &  p  ,    6  zp  F  p  N  p  V  `  \  {      $    F    j              zp  2  `  <  {  J  p  \  p    p    }p    `    `    zp    `     {  
  }p  J  `  R  p  X    `      }p    p    }p  <  p  t  p    }p    `    p            }p  (  }p    p    p  "  p  6  p  	  }p  	(  `  	0  p  	6 /  	B  }p  	\  `  	z  zp  	  `  	  {  	  `  	  `  	  p  	    	 /  	  }p  
  `  
  `  
   p  
&    
. /      @     tP     uP     vP     wP     @   (  @   4  tP   8  P   <  uP   @  @   L  @   P  P   T  uP   X  @   d  @   p  @   |  @     @    (P     P     @     tP                                 &          8d          ]d          t                              π                            J                           ΀                                    ,         D         q                           ɀ         Հ  ^        f        o        q        9      '  >      N        W        b        m        v                           !        "               Ԁ  *               
  .        1      (  2      5  8      @  9      M  :      X  ;      e  <      p  =      }  (        2        7                 <      ̀           =        @        A        B        C      (  D      3  E      <  F      E  G      N  H      W  I      b  J      l  K      w  Z                 c                        !         Z                             F                        	U        	^         	  i      	  t      
  ~      
                   '      ŀ  -      ؀  ;                                        R         ǀ                               $        0        9        D         Ԁ         m p      z         Ӏ w      $  +               	$  7   0  %      0  2     
H  ?        M         V         \         d           D  E       D  F     l         y           D  I                D  L       D  K                D  L               D  P      D  S       D  R  $    D  S  4    D  W  <    D  Z  T    D  [  l             D  ^  z    D  [  ~            D  ^               D  _      D  b      D  e      D  `              D  c      D  e               D  g      D  h      D  k                        D  m      D  p      D  o      D  p  ,    D  s  4    D  u  d  $  E  
H       
d       v    D  {  v    D  ~      D        D                 D        D        D        D        D        D        D        D    *    D    6    D    R    D    Z    D    v    D        D      $  {  
d  @  y     @  y   	  @  y     #  y  ,  y     2  y     8@  |     ?@  |   
  F@  |                       K     
p  V       b           D        D        D    $    D    &    D    D    D    X    D    x    D        D        D        D        D        D        D    H    D    X  i           D    h    D    h    D    j  q$    
p  ~@       @       @     
           @                       h         j       
           D        D        D        D        D        D        D        D        D        D    2    D    :    D    r    D        D        D        D        D        D        D      $    
  @       @     
  @     	  @            
           D        D      $    
       
           D        D    &  ,$    
  :     
  I         D        D        D       D       D       D       D       D       D     Y$    
  j@       s@       y@       @            
           D 
      D       D 
  ,    D   4    D   L    D   V    D   X    D   \  $ 
  
  @ 	     @ 	     @ 	          
                    D       D   	    D   	    D   	     D   	&    D   	6             D    	>    D #  	@    D &  	V    D %  	Z    D '  	b    D *  	h    D ,  	x    D .  	    D 1  	    D 0  	    D 2  	    D 6  	    D 5  	    D 6  	    D 8  	    D ;  	    D :  
    D <  

    D @  
    D ?  
    D @  
&    D D  
6  $   
  @      @                    	         
6  %   )      /   (      >.oVncs .oVgcc2.5.8 gcc2_compiled. ___gnu_compiled_c /usr/local/src/ncurses_1.9.9g/obj_g/ ../ncurses/lib_color.c int:t1=r1;-2147483648;2147483647; char:t2=r1;0;255; long int:t3=r1;-2147483648;2147483647; unsigned int:t4=r1;0;-1; long unsigned int:t5=r1;0;-1; long long int:t6=r1;01000000000000000000000;0777777777777777777777; long long unsigned int:t7=r1;0000000000000;01777777777777777777777; short int:t8=r1;-32768;32767; short unsigned int:t9=r1;0;65535; signed char:t10=r1;-128;127; unsigned char:t11=r1;0;255; float:t12=r1;4;0; double:t13=r1;8;0; long double:t14=r1;8;0; complex int:t15=s8real:1,0,32;imag:1,32,32;; complex float:t16=r16;4;0; complex double:t17=r17;8;0; complex long double:t18=r18;8;0; void:t19=19 ptrdiff_t:t1 size_t:t4 rune_t:t1 wchar_t:t1 div_t:t20=s8quot:1,0,32;rem:1,32,32;; ldiv_t:t21=s8quot:3,0,32;rem:3,32,32;; dev_t:t8 u_char:t11 u_short:t9 u_int:t4 u_long:t5 ushort:t9 u_quad_t:t5 quad_t:t3 qaddr_t:t22=*3 _physadr:T23=s2r:24=ar1;0;0;8,0,16;; physadr:t25=*23 label_t:T26=s44val:27=ar1;0;10;1,0,352;; label_t:t26 vm_offset_t:t5 vm_size_t:t5 int8_t:t10 u_int8_t:t11 int16_t:t8 u_int16_t:t9 int32_t:t1 u_int32_t:t4 clock_t:t5 ssize_t:t1 time_t:t3 _uquad:T28=s8val:29=ar1;0;1;5,0,64;; u_quad:t28 _quad:T30=s8val:31=ar1;0;1;3,0,64;; quad:t30 daddr_t:t3 caddr_t:t32=*2 ino_t:t5 swblk_t:t3 segsz_t:t3 off_t:t3 uid_t:t9 gid_t:t9 pid_t:t8 nlink_t:t9 mode_t:t9 fixpt_t:t5 fd_mask:t3 fd_set:T33=s32fds_bits:34=ar1;0;7;3,0,256;; fd_set:t33 timeval:T35=s8tv_sec:3,0,32;tv_usec:3,32,32;; timezone:T36=s8tz_minuteswest:1,0,32;tz_dsttime:1,32,32;; itimerval:T37=s16it_interval:35,0,64;it_value:35,64,64;; timeadj:T38=s20ta_time:35,0,64;ta_rate:35,64,64;ta_flags:1,128,32;; clockinfo:T39=s16hz:1,0,32;tick:1,32,32;stathz:1,64,32;profhz:1,96,32;; tm:T40=s44tm_sec:1,0,32;tm_min:1,32,32;tm_hour:1,64,32;tm_mday:1,96,32;tm_mon:1,128,32;tm_year:1,160,32;tm_wday:1,192,32;tm_yday:1,224,32;tm_isdst:1,256,32;tm_gmtoff:3,288,32;tm_zone:32,320,32;; fpos_t:t3 __sbuf:T41=s8_base:42=*11,0,32;_size:1,32,32;; __sFILE:T43=s84_p:42,0,32;_r:1,32,32;_w:1,64,32;_flags:8,96,16;_file:8,112,16;_bf:41,128,64;_lbfsize:1,192,32;_cookie:44=*19,224,32;_close:45=*46=f1,256,32;_read:47=*48=f1,288,32;_seek:49=*50=f3,320,32;_write:51=*52=f1,352,32;_ub:41,384,64;_up:42,448,32;_ur:1,480,32;_ubuf:53=ar1;0;2;11,512,24;_nbuf:54=ar1;0;0;11,536,8;_lb:41,544,64;_blksize:1,608,32;_offset:3,640,32;; FILE:t43 try:T55=s12child:56=*55,0,32;sibling:56,32,32;ch:11,64,8;value:9,80,16;; slk_ent:t57=s16text:32,0,32;form_text:32,32,32;x:1,64,32;dirty:2,96,8;visible:2,104,8;; SLK:t58=s24dirty:2,0,8;hidden:2,8,8;win:59=*60,32,32;ch:11,64,8;value:9,80,16;; slk_ent:t57=s16text:32,0,32;form_text:32,32,32;x:1,64,32;dirty:2,96,8;visible:2,104,8;; SLK:t58=s24dirty:2,0,8;hidden:2,8,8;win:59=*60,32,32;ent:61=*57,64,32;buffer:32,96,32;maxlab:8,128,16;labcnt:8,144,16;maxlen:8,160,16;; color_t:t62=s6red:8,0,16;green:8,16,16;blue:8,32,16;; screen:T63=s488_ifd:1,0,32;_ofp:64=*43,32,32;_checkfd:1,64,32;_term:65=*66,96,32;_lines:8,128,16;_columns:8,144,16;_lines_avail:8,160,16;_topstolen:8,176,16;_curscr:59,192,32;_newscr:59,224,32;_stdscr:59,256,32;_keytry:56,288,32;_fifo:67=ar1;0;65;4,320,2112;_fifohead:10,2432,8;_fifotail:10,2440,8;_fifopeek:10,2448,8;_endwin:1,2464,32;_current_attr:5,2496,32;_coloron:1,2528,32;_cursor:1,2560,32;_cursrow:1,2592,32;_curscol:1,2624,32;_nl:1,2656,32;_raw:1,2688,32;_cbreak:1,2720,32;_echo:1,2752,32;_use_meta:1,2784,32;_slk:68=*58,2816,32;_baudrate:1,2848,32;_char_padding:1,2880,32;_cr_cost:1,2912,32;_cup_cost:1,2944,32;_home_cost:1,2976,32;_ll_cost:1,3008,32;_cub1_cost:1,3040,32;_cuf1_cost:1,3072,32;_cud1_cost:1,3104,32;_cuu1_cost:1,3136,32;_cub_cost:1,3168,32;_cuf_cost:1,3200,32;_cud_cost:1,3232,32;_cuu_cost:1,3264,32;_hpa_cost:1,3296,32;_vpa_cost:1,3328,32;_ed_cost:1,3360,32;_el_cost:1,3392,32;_el1_cost:1,3424,32;_dch1_cost:1,3456,32;_ich1_cost:1,3488,32;_dch_cost:1,3520,32;_ich_cost:1,3552,32;_ech_cost:1,3584,32;_rep_cost:1,3616,32;_address_cursor:32,3648,32;_carriage_return_length:1,3680,32;_cursor_home_length:1,3712,32;_cursor_to_ll_length:1,3744,32;_color_table:69=*62,3776,32;_color_count:1,3808,32;_color_pairs:42,3840,32;_pair_count:1,3872,32;; chtype:t5 va_list:t32 __gnuc_va_list:t32 bool:t4 SCREEN:t63 WINDOW:t60 attr_t:t5 ldat:T70=s12text:71=*5,0,32;firstchar:8,32,16;lastchar:8,48,16;oldindex:8,64,16;; pdat:T72=s12_pad_y:8,0,16;_pad_x:8,16,16;_pad_top:8,32,16;_pad_left:8,48,16;_pad_bottom:8,64,16;_pad_right:8,80,16;; _win_st:T60=s100_cury:8,0,16;_curx:8,16,16;_maxy:8,32,16;_maxx:8,48,16;_begy:8,64,16;_begx:8,80,16;_flags:8,96,16;_attrs:5,128,32;_bkgd:5,160,32;_notimeout:4,192,32;_checkfd:1,64,32;_term:65=*66,96,32;_lines:8,128,16;_columns:8,144,16;_lines_avail:8,160,16;_topstolen:8,176,16;_curscr:59,192,32;_newscr:59,224,32;_stdscr:59,256,32;_keytry:56,288,32;_fifo:67=ar1;0;65;4,320,2112;_fifohead:10,2432,8;_fifotail:10,2440,8;_fifopeek:10,2448,8;_endwin:1,2464,32;_current_attr:5,2496,32;_coloron:1,2528,32;_cursor:1,2560,32;_cursrow:1,2592,32;_curscol:1,2624,32;_nl:1,2656,32;_raw:1,2688,32;_cbreak:1,2720,32;_echo:1,2752,32;_use_meta:1,2784,32;_slk:68=*58,2816,32;_baudrate:1,2848,32;_char_padding:1,2880,32;_cr_cost:1,2912,32;_cup_cost:1,2944,32;_home_cost:1,2976,32;_ll_cost:1,3008,32;_cub1_cost:1,3040,32;_cuf1_cost:1,3072,32;_cud1_cost:1,3104,32;_cuu1_cost:1,3136,32;_cub_cost:1,3168,32;_cuf_cost:1,3200,32;_cud_cost:1,3232,32;_cuu_cost:1,3264,32;_hpa_cost:1,3296,32;_vpa_cost:1,3328,32;_ed_cost:1,3360,32;_el_cost:1,3392,32;_el1_cost:1,3424,32;_dch1_cost:1,3456,32;_ich1_cost:1,3488,32;_dch_cost:1,3520,32;_ich_cost:1,3552,32;_ech_cost:1,3584,32;_rep_cost:1,3616,32;_address_cursor:32,3648,32;_carriage_return_length:1,3680,32;_cursor_home_length:1,3712,32;_cursor_to_ll_length:1,3744,32;_color_table:69=*62,3776,32;_color_count:1,3808,32;_color_pairs:42,3840,32;_pair_count:1,3872,32;; chtype:t5 va_list:t32 __gnuc_va_list:t32 bool:t4 SCREEN:t63 WINDOW:t60 attr_t:t5 ldat:T70=s12text:71=*5,0,32;firstchar:8,32,16;lastchar:8,48,16;oldindex:8,64,16;; pdat:T72=s12_pad_y:8,0,16;_pad_x:8,16,16;_pad_top:8,32,16;_pad_left:8,48,16;_pad_bottom:8,64,16;_pad_right:8,80,16;; _win_st:T60=s100_cury:8,0,16;_curx:8,16,16;_maxy:8,32,16;_maxx:8,48,16;_begy:8,64,16;_begx:8,80,16;_flags:8,96,16;_attrs:5,128,32;_bkgd:5,160,32;_notimeout:4,192,32;_clear:4,224,32;_leaveok:4,256,32;_scroll:4,288,32;_idlok:4,320,32;_idcok:4,352,32;_immed:4,384,32;_sync:4,416,32;_use_keypad:4,448,32;_delay:1,480,32;_line:73=*70,512,32;_regtop:8,544,16;_regbottom:8,560,16;_parx:1,576,32;_pary:1,608,32;_parent:74=*60,640,32;_pad:72,672,96;_yoffset:8,768,16;; mmask_t:t5 MEVENT:t75=s20id:8,0,16;x:1,32,32;y:1,64,32;z:1,96,32;bstate:5,128,32;; ripoff_t:t76=s12line:1,0,32;hook:77=*78=f1,32,32;tms_cutime:3,64,32;tms_cstime:3,96,32;; tcflag_t:t5 cc_t:t11 speed_t:t3 termios:T80=s44c_iflag:5,0,32;c_oflag:5,32,32;c_cflag:5,64,32;c_lflag:5,96,32;c_cc:80=ar1;0;19;11,128,160;c_ispeed:3,288,32;c_ospeed:3,320,32;; termtype:T81=s1780term_names:32,0,32;str_table:32,32,32;Booleans:82=ar1;0;43;2,64,352;Numbers:83=ar1;0;38;8,416,624;Strings:84=ar1;0;411;32,1056,13184;; TERMTYPE:t81 term:T66=s1872type:81,0,14240;Filedes:8,14240,16;Ottyb:79,14272,352;Nttyb:79,14624,352;; TERMINAL:t66 _beep _.beep __tracef _putp __nc_tracing _._tracef _cur_term __nc_tputs_trace _.putp beep:F1 _flash _.flash flash:F1 lib_bkgd.o      865106149   0     103   100644  7085      `
                     (    wbkgd(%p, %lx) called ّn @  D  l uJ 
j0s   "  c  d utL 5R<   @
 @# &4Lk S00eL @dTpD`0dp	    00S10R! RLtb0Q  A u  b  ɑ   @ߘ!                          &  mp   <  `   D  r                @     hP     iP     jP                                 &          8d          ]d          s                              ΀                            I                           ̀                                    +         C         p                           Ȁ         Ԁ  ^        f        o        q         9      &  >      M        V        a        l        u                           !        "               Ӏ  *                 .        1      '  2      4  8      ?  9      L  :      W  ;      d  <      o  =      |  (        2        7                 <      ̀           =        @        A        B        C      '  D      2  E      ;  F      D  G      M  H      V  I      a  J      k  K      v  Z                 c                                  Y                             F                        	T  